/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.authenticator;

import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opensearch.dataprepper.plugins.kafka.authenticator.BasicCredentials;
import org.opensearch.dataprepper.plugins.kafka.configuration.AuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaConnectionConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.PlainTextAuthConfig;

public class DynamicBasicCredentialsProvider {
    private static final DynamicBasicCredentialsProvider singleton = new DynamicBasicCredentialsProvider();
    private BasicCredentials basicCredentials;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public static DynamicBasicCredentialsProvider getInstance() {
        return singleton;
    }

    protected DynamicBasicCredentialsProvider() {
    }

    public BasicCredentials getBasicCredentials() {
        this.readWriteLock.readLock().lock();
        try {
            BasicCredentials basicCredentials = this.basicCredentials;
            return basicCredentials;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(KafkaConnectionConfig newConfig) {
        AuthConfig.SaslAuthConfig saslAuthConfig;
        AuthConfig authConfig = newConfig.getAuthConfig();
        if (Objects.nonNull(authConfig) && Objects.nonNull(saslAuthConfig = authConfig.getSaslAuthConfig()) && Objects.nonNull(saslAuthConfig.getPlainTextAuthConfig())) {
            PlainTextAuthConfig plainTextAuthConfig = newConfig.getAuthConfig().getSaslAuthConfig().getPlainTextAuthConfig();
            String newUsername = plainTextAuthConfig.getUsername();
            String newPassword = plainTextAuthConfig.getPassword();
            this.readWriteLock.writeLock().lock();
            try {
                this.basicCredentials = new BasicCredentials(newUsername, newPassword);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }
}

