/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.jira.utils;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.plugins.source.jira.JiraSourceConfig;
import org.opensearch.dataprepper.plugins.source.jira.utils.AddressValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraConfigHelper {
    private static final Logger log = LoggerFactory.getLogger(JiraConfigHelper.class);

    public static List<String> getIssueStatusIncludeFilter(JiraSourceConfig repositoryConfiguration) {
        if (repositoryConfiguration.getFilterConfig() == null || repositoryConfiguration.getFilterConfig().getStatusConfig() == null) {
            return new ArrayList<String>();
        }
        return repositoryConfiguration.getFilterConfig().getStatusConfig().getInclude();
    }

    public static List<String> getIssueStatusExcludeFilter(JiraSourceConfig repositoryConfiguration) {
        if (repositoryConfiguration.getFilterConfig() == null || repositoryConfiguration.getFilterConfig().getStatusConfig() == null) {
            return new ArrayList<String>();
        }
        return repositoryConfiguration.getFilterConfig().getStatusConfig().getExclude();
    }

    public static List<String> getIssueTypeIncludeFilter(JiraSourceConfig repositoryConfiguration) {
        if (repositoryConfiguration.getFilterConfig() == null || repositoryConfiguration.getFilterConfig().getIssueTypeConfig() == null) {
            return new ArrayList<String>();
        }
        return repositoryConfiguration.getFilterConfig().getIssueTypeConfig().getInclude();
    }

    public static List<String> getIssueTypeExcludeFilter(JiraSourceConfig repositoryConfiguration) {
        if (repositoryConfiguration.getFilterConfig() == null || repositoryConfiguration.getFilterConfig().getIssueTypeConfig() == null) {
            return new ArrayList<String>();
        }
        return repositoryConfiguration.getFilterConfig().getIssueTypeConfig().getExclude();
    }

    public static List<String> getProjectNameIncludeFilter(JiraSourceConfig repositoryConfiguration) {
        if (repositoryConfiguration.getFilterConfig() == null || repositoryConfiguration.getFilterConfig().getProjectConfig() == null || repositoryConfiguration.getFilterConfig().getProjectConfig().getNameConfig() == null) {
            return new ArrayList<String>();
        }
        return repositoryConfiguration.getFilterConfig().getProjectConfig().getNameConfig().getInclude();
    }

    public static List<String> getProjectNameExcludeFilter(JiraSourceConfig repositoryConfiguration) {
        if (repositoryConfiguration.getFilterConfig() == null || repositoryConfiguration.getFilterConfig().getProjectConfig() == null || repositoryConfiguration.getFilterConfig().getProjectConfig().getNameConfig() == null) {
            return new ArrayList<String>();
        }
        return repositoryConfiguration.getFilterConfig().getProjectConfig().getNameConfig().getExclude();
    }

    public static boolean validateConfig(JiraSourceConfig config) {
        if (config.getAccountUrl() == null) {
            throw new RuntimeException("Account URL is missing.");
        }
        if (config.getAuthType() == null) {
            throw new RuntimeException("Authentication Type is missing.");
        }
        String authType = config.getAuthType();
        if (!"OAuth2".equals(authType) && !"Basic".equals(authType)) {
            throw new RuntimeException("Invalid AuthType is given");
        }
        if ("Basic".equals(authType) && (config.getAuthenticationConfig().getBasicConfig().getUsername() == null || config.getAuthenticationConfig().getBasicConfig().getPassword() == null)) {
            throw new RuntimeException("Jira ID or Credential are required for Basic AuthType");
        }
        if ("OAuth2".equals(authType) && (config.getAuthenticationConfig().getOauth2Config().getAccessToken() == null || config.getAuthenticationConfig().getOauth2Config().getRefreshToken() == null)) {
            throw new RuntimeException("Access Token or Refresh Token are required for OAuth2 AuthType");
        }
        AddressValidation.validateInetAddress(AddressValidation.getInetAddress(config.getAccountUrl()));
        return true;
    }
}

