/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.jira.rest;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.net.URI;
import javax.inject.Named;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.AtlassianRestClient;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.auth.AtlassianAuthConfig;
import org.opensearch.dataprepper.plugins.source.jira.models.SearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Named
public class JiraRestClient
extends AtlassianRestClient {
    private static final Logger log = LoggerFactory.getLogger(JiraRestClient.class);
    public static final String REST_API_SEARCH = "rest/api/3/search";
    public static final String REST_API_FETCH_ISSUE = "rest/api/3/issue";
    public static final String FIFTY = "50";
    public static final String START_AT = "startAt";
    public static final String MAX_RESULT = "maxResults";
    private static final String TICKET_FETCH_LATENCY_TIMER = "ticketFetchLatency";
    private static final String SEARCH_CALL_LATENCY_TIMER = "searchCallLatency";
    private static final String TICKETS_REQUESTED = "ticketsRequested";
    private static final String TICKET_REQUESTS_FAILED = "ticketRequestsFailed";
    private static final String TICKET_REQUESTS_SUCCESS = "ticketRequestsSuccess";
    private static final String SEARCH_REQUESTS_FAILED = "searchRequestsFailed";
    private final RestTemplate restTemplate;
    private final AtlassianAuthConfig authConfig;
    private final Timer ticketFetchLatencyTimer;
    private final Timer searchCallLatencyTimer;
    private final Counter ticketsRequestedCounter;
    private final Counter ticketRequestsFailedCounter;
    private final Counter ticketRequestsSuccessCounter;
    private final Counter searchRequestsFailedCounter;

    public JiraRestClient(RestTemplate restTemplate, AtlassianAuthConfig authConfig, PluginMetrics pluginMetrics) {
        super(restTemplate, authConfig, pluginMetrics);
        this.restTemplate = restTemplate;
        this.authConfig = authConfig;
        this.ticketFetchLatencyTimer = pluginMetrics.timer(TICKET_FETCH_LATENCY_TIMER);
        this.searchCallLatencyTimer = pluginMetrics.timer(SEARCH_CALL_LATENCY_TIMER);
        this.ticketsRequestedCounter = pluginMetrics.counter(TICKETS_REQUESTED);
        this.ticketRequestsFailedCounter = pluginMetrics.counter(TICKET_REQUESTS_FAILED);
        this.ticketRequestsSuccessCounter = pluginMetrics.counter(TICKET_REQUESTS_SUCCESS);
        this.searchRequestsFailedCounter = pluginMetrics.counter(SEARCH_REQUESTS_FAILED);
    }

    public SearchResults getAllIssues(StringBuilder jql, int startAt) {
        String url = this.authConfig.getUrl() + REST_API_SEARCH;
        URI uri = UriComponentsBuilder.fromHttpUrl((String)url).queryParam(MAX_RESULT, new Object[]{FIFTY}).queryParam(START_AT, new Object[]{startAt}).queryParam("jql", new Object[]{jql}).queryParam("expand", new Object[]{"all"}).buildAndExpand(new Object[0]).toUri();
        return (SearchResults)this.searchCallLatencyTimer.record(() -> {
            try {
                return (SearchResults)this.invokeRestApi(uri, SearchResults.class).getBody();
            }
            catch (Exception e) {
                log.error(DataPrepperMarkers.NOISY, "Error while fetching issues with jql {}", (Object)jql, (Object)e);
                this.searchRequestsFailedCounter.increment();
                throw e;
            }
        });
    }

    public String getIssue(String issueKey) {
        this.ticketsRequestedCounter.increment();
        String url = this.authConfig.getUrl() + "rest/api/3/issue/" + issueKey;
        URI uri = UriComponentsBuilder.fromHttpUrl((String)url).buildAndExpand(new Object[0]).toUri();
        return (String)this.ticketFetchLatencyTimer.record(() -> {
            try {
                String body = (String)this.invokeRestApi(uri, String.class).getBody();
                this.ticketRequestsSuccessCounter.increment();
                return body;
            }
            catch (Exception e) {
                log.error("Error while fetching issue with key {}", (Object)issueKey);
                this.ticketRequestsFailedCounter.increment();
                throw e;
            }
        });
    }
}

