/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.http;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.throttling.ThrottlingRejectHandler;
import io.micrometer.core.instrument.Counter;
import javax.annotation.Nullable;
import org.opensearch.dataprepper.metrics.PluginMetrics;

public class LogThrottlingRejectHandler
implements ThrottlingRejectHandler<HttpRequest, HttpResponse> {
    public static final String REQUESTS_REJECTED = "requestsRejected";
    private final int maxPendingRequests;
    private final Counter rejectedRequestsCounter;

    public LogThrottlingRejectHandler(int maxPendingRequests, PluginMetrics pluginMetrics) {
        this.maxPendingRequests = maxPendingRequests;
        this.rejectedRequestsCounter = pluginMetrics.counter(REQUESTS_REJECTED);
    }

    public HttpResponse handleRejected(Service<HttpRequest, HttpResponse> delegate, ServiceRequestContext ctx, HttpRequest req, @Nullable Throwable cause) throws Exception {
        this.rejectedRequestsCounter.increment();
        return HttpResponse.of((HttpStatus)HttpStatus.TOO_MANY_REQUESTS, (MediaType)MediaType.ANY_TYPE, (String)"The number of pending requests in the work queue reaches max_pending_requests:%d. Please retry later", (Object[])new Object[]{this.maxPendingRequests});
    }
}

