/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.truststore;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.opensearch.dataprepper.plugins.truststore.X509TrustAllManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustStoreProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TrustStoreProvider.class);

    public static TrustManager[] createTrustManager(Path certificatePath) {
        LOG.info("Using the certificate path {} to create trust manager.", (Object)certificatePath.toString());
        try {
            KeyStore keyStore = TrustStoreProvider.createKeyStore(certificatePath);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static TrustManager[] createTrustManager(String certificateContent) {
        TrustManager[] trustManagerArray;
        LOG.info("Using the certificate content to create trust manager.");
        ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(certificateContent.getBytes());
        try {
            KeyStore keyStore = TrustStoreProvider.createKeyStore(certificateInputStream);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
            trustManagerFactory.init(keyStore);
            trustManagerArray = trustManagerFactory.getTrustManagers();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)certificateInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        ((InputStream)certificateInputStream).close();
        return trustManagerArray;
    }

    public static TrustManager[] createTrustAllManager() {
        LOG.info("Using the trust all manager to create trust manager.");
        return new TrustManager[]{new X509TrustAllManager()};
    }

    private static KeyStore createKeyStore(Path certificatePath) throws Exception {
        try (InputStream certificateInputStream = Files.newInputStream(certificatePath, new OpenOption[0]);){
            KeyStore keyStore = TrustStoreProvider.createKeyStore(certificateInputStream);
            return keyStore;
        }
    }

    private static KeyStore createKeyStore(InputStream trustStoreInputStream, String password) throws Exception {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(trustStoreInputStream, password.toCharArray());
        return trustStore;
    }

    private static KeyStore createKeyStore(InputStream certificateInputStream) throws Exception {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        Certificate trustedCa = factory.generateCertificate(certificateInputStream);
        KeyStore trustStore = KeyStore.getInstance("pkcs12");
        trustStore.load(null, null);
        trustStore.setCertificateEntry("ca", trustedCa);
        return trustStore;
    }

    public static SSLContext createSSLContext(Path certificatePath) {
        SSLContext sSLContext;
        block8: {
            LOG.info("Using the certificate path to create SSL context.");
            InputStream is = Files.newInputStream(certificatePath, new OpenOption[0]);
            try {
                sSLContext = TrustStoreProvider.createSSLContext(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            is.close();
        }
        return sSLContext;
    }

    public static SSLContext createSSLContext(Path trustStorePath, String password) {
        SSLContext sSLContext;
        block8: {
            LOG.info("Using the truststore path and password to create SSL context.");
            InputStream is = Files.newInputStream(trustStorePath, new OpenOption[0]);
            try {
                sSLContext = TrustStoreProvider.createSSLContext(is, password);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            is.close();
        }
        return sSLContext;
    }

    public static SSLContext createSSLContext(String certificateContent) {
        SSLContext sSLContext;
        LOG.info("Using the certificate content to create SSL context.");
        ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(certificateContent.getBytes());
        try {
            sSLContext = TrustStoreProvider.createSSLContext(certificateInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)certificateInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        ((InputStream)certificateInputStream).close();
        return sSLContext;
    }

    private static SSLContext createSSLContext(InputStream certificateInputStream) throws Exception {
        KeyStore trustStore = TrustStoreProvider.createKeyStore(certificateInputStream);
        return SSLContexts.custom().loadTrustMaterial(trustStore, null).build();
    }

    private static SSLContext createSSLContext(InputStream certificateInputStream, String password) throws Exception {
        KeyStore trustStore = TrustStoreProvider.createKeyStore(certificateInputStream, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        SSLContext.setDefault(sslContext);
        return sslContext;
    }

    public static SSLContext createSSLContextWithTrustAllStrategy() {
        LOG.info("Using the trust all strategy to create SSL context.");
        try {
            return SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) {
                    return true;
                }
            }).build();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

