/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.processor;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.plugins.geoip.GeoIPField;

@JsonPropertyOrder
@JsonClassDescription(value="Defines a single entry for geolocation.")
public class EntryConfig {
    static final String DEFAULT_TARGET = "geo";
    @JsonPropertyDescription(value="The key of the source field containing the IP address to geolocate.")
    @JsonProperty(value="source")
    @NotEmpty
    private String source;
    @JsonPropertyDescription(value="The key of the target field in which to set the geolocation data.")
    @JsonProperty(value="target", defaultValue="geo")
    private String target = "geo";
    @JsonPropertyDescription(value="The list of geolocation fields to include in the target object. By default, this is all the fields provided by the configured databases. For example, if you wish to only obtain the actual location, you can specify <code>location</code>.")
    @JsonProperty(value="include_fields")
    @ExampleValues(value={@ExampleValues.Example(value="[location, latitude, longitude]", description="The processor will include these fields while extracting geolocation data.")})
    private List<String> includeFields;
    @JsonPropertyDescription(value="The list of geolocation fields to exclude from the target object. For example, you can exclude ASN fields by including <code>asn</code>, <code>asn_organization</code>, <code>network</code>, <code>ip</code>.")
    @JsonProperty(value="exclude_fields")
    @ExampleValues(value={@ExampleValues.Example(value="[asn, asn_organization, network]", description="The processor will exclude these fields while extracting geolocation data.")})
    private List<String> excludeFields;

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    List<String> getIncludeFields() {
        return this.includeFields;
    }

    List<String> getExcludeFields() {
        return this.excludeFields;
    }

    @AssertTrue(message="include_fields and exclude_fields are mutually exclusive. include_fields or exclude_fields is required.")
    @AssertTrue(message="include_fields and exclude_fields are mutually exclusive. include_fields or exclude_fields is required.") boolean areFieldsValid() {
        if (this.includeFields == null && this.excludeFields == null) {
            return false;
        }
        return this.includeFields == null || this.excludeFields == null;
    }

    @JsonIgnore
    public Collection<GeoIPField> getGeoIPFields() {
        if (this.includeFields != null && !this.includeFields.isEmpty()) {
            EnumSet<GeoIPField> geoIPFields = EnumSet.noneOf(GeoIPField.class);
            for (String field : this.includeFields) {
                GeoIPField geoIPField = GeoIPField.findByName(field);
                if (geoIPField == null) continue;
                geoIPFields.add(geoIPField);
            }
            return geoIPFields;
        }
        if (this.excludeFields != null) {
            EnumSet<GeoIPField> geoIPFields = EnumSet.allOf(GeoIPField.class);
            for (String field : this.excludeFields) {
                GeoIPField geoIPField = GeoIPField.findByName(field);
                if (geoIPField == null) continue;
                geoIPFields.remove((Object)geoIPField);
            }
            return geoIPFields;
        }
        return GeoIPField.allFields();
    }
}

