/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.LicenseTypeOptions;

class LicenseTypeCheck {
    private static final String GEOIP2_DATABASE = "geoip2";
    private static final String GEOLITE2_DATABASE = "geolite2";
    private static final String MMDB = "mmdb";

    public LicenseTypeOptions isGeoLite2OrEnterpriseLicense(String databasePath) {
        LicenseTypeOptions licenseTypeOptions = null;
        File directory = new File(databasePath);
        if (directory.isDirectory()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                String fileName = file.toString();
                int index = fileName.lastIndexOf(46);
                if (index <= 0) continue;
                String extension = fileName.substring(index + 1);
                Path onlyFileName = Paths.get(fileName, new String[0]).getFileName();
                if (extension.equals(MMDB) && onlyFileName.toString().toLowerCase().contains(GEOIP2_DATABASE)) {
                    licenseTypeOptions = LicenseTypeOptions.ENTERPRISE;
                    break;
                }
                if (!extension.equals(MMDB) || !onlyFileName.toString().toLowerCase().contains(GEOLITE2_DATABASE)) continue;
                licenseTypeOptions = LicenseTypeOptions.FREE;
            }
        }
        return licenseTypeOptions;
    }
}

