/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.dataprepper.plugins.geoip.GeoIPDatabase;
import org.opensearch.dataprepper.plugins.geoip.GeoIPField;
import org.opensearch.dataprepper.plugins.geoip.extension.api.GeoIPDatabaseReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutoCountingDatabaseReader
implements GeoIPDatabaseReader {
    private static final Logger LOG = LoggerFactory.getLogger(AutoCountingDatabaseReader.class);
    private final GeoIPDatabaseReader delegateDatabaseReader;
    private final AtomicInteger closeCount;

    public AutoCountingDatabaseReader(GeoIPDatabaseReader geoIPDatabaseReader) {
        this.delegateDatabaseReader = geoIPDatabaseReader;
        this.closeCount = new AtomicInteger(1);
    }

    @Override
    public Map<String, Object> getGeoData(InetAddress inetAddress, Collection<GeoIPField> fields, Collection<GeoIPDatabase> geoIPDatabases) {
        return this.delegateDatabaseReader.getGeoData(inetAddress, fields, geoIPDatabases);
    }

    @Override
    public boolean isExpired() {
        return this.delegateDatabaseReader.isExpired();
    }

    @Override
    public void retain() {
        this.closeCount.incrementAndGet();
    }

    @Override
    public void close() throws Exception {
        int count = this.closeCount.decrementAndGet();
        if (count == 0) {
            LOG.debug("Closing old geoip database readers");
            this.delegateDatabaseReader.close();
        }
    }
}

