/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension.databasedownload;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.opensearch.dataprepper.plugins.geoip.exception.DownloadFailedException;
import org.opensearch.dataprepper.plugins.geoip.extension.MaxMindDatabaseConfig;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.DBSource;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.GeoIPFileManager;

public class HttpDBDownloadService
implements DBSource {
    private final String destinationDirectory;
    private static final int DEFAULT_BYTE_SIZE = 1024;
    private final GeoIPFileManager geoIPFileManager;
    private final MaxMindDatabaseConfig maxMindDatabaseConfig;

    public HttpDBDownloadService(String destinationDirectory, GeoIPFileManager geoIPFileManager, MaxMindDatabaseConfig maxMindDatabaseConfig) {
        this.destinationDirectory = destinationDirectory;
        this.geoIPFileManager = geoIPFileManager;
        this.maxMindDatabaseConfig = maxMindDatabaseConfig;
    }

    @Override
    public void initiateDownload() {
        String tarDir = this.destinationDirectory + File.separator + "tar";
        String downloadTarFilepath = tarDir + File.separator + "out.tar.gz";
        Set<String> databasePaths = this.maxMindDatabaseConfig.getDatabasePaths().keySet();
        for (String key : databasePaths) {
            this.geoIPFileManager.createDirectoryIfNotExist(tarDir);
            try {
                this.initiateSSL();
                this.buildRequestAndDownloadFile(this.maxMindDatabaseConfig.getDatabasePaths().get(key), downloadTarFilepath);
                File tarFile = this.decompressAndgetTarFile(tarDir, downloadTarFilepath);
                HttpDBDownloadService.unTarFile(tarFile, new File(this.destinationDirectory), key);
                this.deleteTarFolder(tarDir);
            }
            catch (Exception ex) {
                throw new DownloadFailedException("Failed to download from " + this.maxMindDatabaseConfig.getDatabasePaths().get(key) + " due to: " + ex.getMessage());
            }
        }
    }

    private File decompressAndgetTarFile(String tarFolderPath, String downloadTarFilepath) {
        try {
            File inputFile = new File(downloadTarFilepath);
            String outputFile = HttpDBDownloadService.getFileName(inputFile, tarFolderPath);
            File tarFile = new File(outputFile);
            return HttpDBDownloadService.deCompressGZipFile(inputFile, tarFile);
        }
        catch (IOException ex) {
            throw new DownloadFailedException("Failed to decompress GZip file." + ex.getMessage());
        }
    }

    public void buildRequestAndDownloadFile(String url, String downloadTarFilepath) {
        HttpDBDownloadService.downloadDBFileFromMaxmind(url, downloadTarFilepath);
    }

    private void deleteTarFolder(String tarFolder) {
        File file = new File(tarFolder);
        this.geoIPFileManager.deleteDirectory(file);
        if (file.exists()) {
            file.delete();
        }
    }

    private static void downloadDBFileFromMaxmind(String maxmindDownloadUrl, String tarFilepath) {
        try (BufferedInputStream in = new BufferedInputStream(new URL(maxmindDownloadUrl).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(tarFilepath);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            throw new DownloadFailedException("Failed to download from " + maxmindDownloadUrl + " due to: " + ex.getMessage());
        }
    }

    private static File deCompressGZipFile(File gZippedFile, File tarFile) throws IOException {
        int len;
        FileInputStream fileInputStream = new FileInputStream(gZippedFile);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(tarFile);
        byte[] buffer = new byte[1024];
        while ((len = gZIPInputStream.read(buffer)) > 0) {
            fileOutputStream.write(buffer, 0, len);
        }
        fileOutputStream.close();
        gZIPInputStream.close();
        return tarFile;
    }

    private static String getFileName(File inputFile, String outputFolder) {
        return outputFolder + File.separator + inputFile.getName().substring(0, inputFile.getName().lastIndexOf(46));
    }

    private static void unTarFile(File tarFile, File destDir, String fileName) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(tarFile);
        TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)fileInputStream);
        TarArchiveEntry tarEntry = null;
        while ((tarEntry = tarArchiveInputStream.getNextTarEntry()) != null) {
            if (!tarEntry.getName().endsWith(".mmdb")) continue;
            File outputFile = new File(String.valueOf(destDir) + File.separator + fileName + ".mmdb");
            if (tarEntry.isDirectory()) {
                if (outputFile.exists()) continue;
                outputFile.mkdirs();
                continue;
            }
            outputFile.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
            IOUtils.copy((InputStream)tarArchiveInputStream, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        tarArchiveInputStream.close();
    }
}

