/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.dataprepper.plugins.geoip.extension.DatabaseSourceIdentification;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.DBSourceOptions;

public class MaxMindDatabaseConfig {
    static final String DEFAULT_CITY_ENDPOINT = "https://geoip.maps.opensearch.org/v1/mmdb/geolite2-city/manifest.json";
    static final String DEFAULT_COUNTRY_ENDPOINT = "https://geoip.maps.opensearch.org/v1/mmdb/geolite2-country/manifest.json";
    static final String DEFAULT_ASN_ENDPOINT = "https://geoip.maps.opensearch.org/v1/mmdb/geolite2-asn/manifest.json";
    public static final String GEOLITE2_COUNTRY = "geolite2-country";
    public static final String GEOLITE2_CITY = "geolite2-city";
    public static final String GEOLITE2_ASN = "geolite2-asn";
    public static final String GEOIP2_ENTERPRISE = "geoip2-enterprise";
    private Map<String, String> databases = null;
    @JsonProperty(value="city")
    private String cityDatabase;
    @JsonProperty(value="country")
    private String countryDatabase;
    @JsonProperty(value="asn")
    private String asnDatabase;
    @JsonProperty(value="enterprise")
    private String enterpriseDatabase;

    @AssertTrue(message="MaxMind GeoLite2 databases cannot be used along with enterprise database.")
    public @AssertTrue(message="MaxMind GeoLite2 databases cannot be used along with enterprise database.") boolean isDatabasesValid() {
        return this.enterpriseDatabase == null || this.cityDatabase == null && this.countryDatabase == null && this.asnDatabase == null;
    }

    @AssertTrue(message="database_paths should be S3 URI or HTTP endpoint or local directory")
    public @AssertTrue(message="database_paths should be S3 URI or HTTP endpoint or local directory") boolean isPathsValid() {
        ArrayList<String> databasePaths = new ArrayList<String>(this.getDatabasePaths().values());
        DBSourceOptions dbSourceOptions = DatabaseSourceIdentification.getDatabasePathType(databasePaths);
        return dbSourceOptions != null;
    }

    public Map<String, String> getDatabasePaths() {
        if (this.databases == null) {
            this.databases = new HashMap<String, String>();
            if (this.countryDatabase == null && this.cityDatabase == null && this.asnDatabase == null && this.enterpriseDatabase == null) {
                this.databases.put(GEOLITE2_COUNTRY, DEFAULT_COUNTRY_ENDPOINT);
                this.databases.put(GEOLITE2_CITY, DEFAULT_CITY_ENDPOINT);
                this.databases.put(GEOLITE2_ASN, DEFAULT_ASN_ENDPOINT);
            } else {
                if (this.countryDatabase != null) {
                    this.databases.put(GEOLITE2_COUNTRY, this.countryDatabase);
                }
                if (this.cityDatabase != null) {
                    this.databases.put(GEOLITE2_CITY, this.cityDatabase);
                }
                if (this.asnDatabase != null) {
                    this.databases.put(GEOLITE2_ASN, this.asnDatabase);
                }
                if (this.enterpriseDatabase != null) {
                    this.databases.put(GEOIP2_ENTERPRISE, this.enterpriseDatabase);
                }
            }
        }
        return this.databases;
    }
}

