/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension;

import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opensearch.dataprepper.plugins.geoip.extension.GeoIPDatabaseManager;
import org.opensearch.dataprepper.plugins.geoip.extension.GeoIpServiceConfig;
import org.opensearch.dataprepper.plugins.geoip.extension.MaxMindConfig;
import org.opensearch.dataprepper.plugins.geoip.extension.api.GeoIPDatabaseReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIPProcessorService {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIPProcessorService.class);
    private final MaxMindConfig maxMindConfig;
    private final GeoIPDatabaseManager geoIPDatabaseManager;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private ExecutorService executorService = null;

    public GeoIPProcessorService(GeoIpServiceConfig geoIpServiceConfig, GeoIPDatabaseManager geoIPDatabaseManager, ReentrantReadWriteLock.ReadLock readLock) {
        this.maxMindConfig = geoIpServiceConfig.getMaxMindConfig();
        this.geoIPDatabaseManager = geoIPDatabaseManager;
        this.readLock = readLock;
        try {
            geoIPDatabaseManager.initiateDatabaseDownload();
        }
        catch (Exception e) {
            LOG.error("Failed to initialize geoip processor due to: {}. Will update with backoff.", (Object)e.getMessage());
        }
    }

    public GeoIPDatabaseReader getGeoIPDatabaseReader() {
        this.readLock.lock();
        try {
            GeoIPDatabaseReader geoIPDatabaseReader = this.geoIPDatabaseManager.getGeoIPDatabaseReader();
            if (geoIPDatabaseReader != null) {
                geoIPDatabaseReader.retain();
            }
            this.checkAndUpdateDatabases();
            GeoIPDatabaseReader geoIPDatabaseReader2 = geoIPDatabaseReader;
            return geoIPDatabaseReader2;
        }
        catch (Exception e) {
            LOG.error("Failed to update databases: {}", (Object)e.getMessage());
            GeoIPDatabaseReader geoIPDatabaseReader = null;
            return geoIPDatabaseReader;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private synchronized void checkAndUpdateDatabases() {
        if (this.geoIPDatabaseManager.getNextUpdateAt().isBefore(Instant.now())) {
            LOG.info("Trying to update geoip Database readers");
            this.geoIPDatabaseManager.setNextUpdateAt(Instant.now().plus(this.maxMindConfig.getDatabaseRefreshInterval()));
            this.executorService = Executors.newSingleThreadExecutor();
            this.executorService.execute(this.geoIPDatabaseManager::updateDatabaseReader);
            this.executorService.shutdown();
        }
    }

    public void shutdown() {
        if (this.executorService != null) {
            try {
                if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executorService.shutdownNow();
            }
        }
        this.geoIPDatabaseManager.deleteDatabasesOnShutdown();
    }
}

