/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.DBSourceOptions;

class DatabaseSourceIdentification {
    private static final String S3_DOMAIN_PATTERN = "[a-zA-Z0-9-]+\\.s3\\.amazonaws\\.com";
    private static final String MANIFEST_ENDPOINT_PATH = "manifest.json";

    private DatabaseSourceIdentification() {
    }

    public static boolean isS3Uri(String uriString) {
        try {
            URI uri = new URI(uriString);
            if (uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("s3")) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isURL(String input) {
        try {
            URI uri = new URI(input);
            URL url = new URL(input);
            return !input.endsWith(MANIFEST_ENDPOINT_PATH) && !uri.getHost().contains("geoip.maps.opensearch") && uri.getHost().equals("download.maxmind.com") && uri.getScheme() != null && !Pattern.matches(S3_DOMAIN_PATTERN, url.getHost()) && (uri.getScheme().equals("http") || uri.getScheme().equals("https"));
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    public static boolean isFilePath(String input) {
        File file = new File(input);
        return file.exists() && file.isFile();
    }

    public static boolean isCDNEndpoint(String input) {
        if (input.endsWith(MANIFEST_ENDPOINT_PATH)) {
            try {
                URI uri = new URI(input);
                return uri.getScheme().equals("http") || uri.getScheme().equals("https");
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return false;
    }

    public static DBSourceOptions getDatabasePathType(List<String> databasePaths) {
        DBSourceOptions downloadSourceOptions = null;
        for (String databasePath : databasePaths) {
            if (DatabaseSourceIdentification.isFilePath(databasePath)) {
                return DBSourceOptions.PATH;
            }
            if (DatabaseSourceIdentification.isCDNEndpoint(databasePath)) {
                return DBSourceOptions.HTTP_MANIFEST;
            }
            if (DatabaseSourceIdentification.isURL(databasePath)) {
                return DBSourceOptions.URL;
            }
            if (!DatabaseSourceIdentification.isS3Uri(databasePath)) continue;
            return DBSourceOptions.S3;
        }
        return downloadSourceOptions;
    }
}

