/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension.databasedownload;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.opensearch.dataprepper.plugins.geoip.exception.DownloadFailedException;
import org.opensearch.dataprepper.plugins.geoip.extension.AwsAuthenticationOptionsConfig;
import org.opensearch.dataprepper.plugins.geoip.extension.MaxMindDatabaseConfig;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.DBSource;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class S3DBService
implements DBSource {
    private final AwsAuthenticationOptionsConfig awsAuthenticationOptionsConfig;
    private final String destinationDirectory;
    private final MaxMindDatabaseConfig maxMindDatabaseConfig;

    public S3DBService(AwsAuthenticationOptionsConfig awsAuthenticationOptionsConfig, String destinationDirectory, MaxMindDatabaseConfig maxMindDatabaseConfig) {
        this.awsAuthenticationOptionsConfig = awsAuthenticationOptionsConfig;
        this.destinationDirectory = destinationDirectory;
        this.maxMindDatabaseConfig = maxMindDatabaseConfig;
    }

    @Override
    public void initiateDownload() {
        Set<String> databasePaths = this.maxMindDatabaseConfig.getDatabasePaths().keySet();
        for (String database : databasePaths) {
            try {
                String s3Uri = this.maxMindDatabaseConfig.getDatabasePaths().get(database);
                URI uri = new URI(s3Uri);
                String key = uri.getPath().substring(1);
                String bucketName = uri.getHost();
                this.buildRequestAndDownloadFile(bucketName, key, database);
            }
            catch (URISyntaxException ex) {
                throw new DownloadFailedException("Failed to download database from S3." + ex.getMessage());
            }
        }
    }

    private void buildRequestAndDownloadFile(String bucketName, String key, String fileName) {
        try {
            S3Client s3Client = this.createS3Client();
            File destination = new File(this.destinationDirectory + File.separator + fileName + ".mmdb");
            s3Client.getObject(b -> b.bucket(bucketName).key(key), destination.toPath());
        }
        catch (Exception ex) {
            throw new DownloadFailedException("Failed to download database from S3." + ex.getMessage());
        }
    }

    private S3Client createS3Client() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(this.awsAuthenticationOptionsConfig.getAwsRegion())).credentialsProvider(this.awsAuthenticationOptionsConfig.authenticateAwsConfiguration())).build();
    }
}

