/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.flatten;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.AlsoRequired;
import org.opensearch.dataprepper.model.annotations.ExampleValues;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>flatten</code>  processor transforms nested objects inside of events into flattened structures.")
public class FlattenProcessorConfig {
    static final String REMOVE_LIST_INDICES_KEY = "remove_list_indices";
    private static final List<String> DEFAULT_EXCLUDE_KEYS = new ArrayList<String>();
    @NotNull
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="The source key on which to perform the operation. If set to an empty string (<code>\"\"</code>), then the processor uses the root of the event as the source.")
    @ExampleValues(value={@ExampleValues.Example(value="key2", description="The flatten operation is performed on the source key equivalent to 'key2'")})
    private String source;
    @NotNull
    @JsonProperty(value="target")
    @JsonPropertyDescription(value="The target key to put into the flattened fields. If set to an empty string (<code>\"\"</code>) then the processor uses the root of the event as the target.")
    @ExampleValues(value={@ExampleValues.Example(value="flattened-key2", description="The flattened fields from the source key specified are put into a field named 'flattened-key2'.")})
    private String target;
    @JsonProperty(value="remove_source_keys")
    @JsonAlias(value={"remove_processed_fields"})
    @JsonPropertyDescription(value="When <code>true</code>, the processor removes all processed fields from the source. The default is <code>false</code> which leaves the source fields.")
    private boolean removeProcessedFields = false;
    @JsonProperty(value="remove_list_elements")
    @JsonAlias(value={"remove_list_indices"})
    @JsonPropertyDescription(value="When <code>true</code>, the processor converts the fields from the source map into lists and puts the lists into the target field. Default is <code>false</code>.")
    private boolean removeListIndices = false;
    @JsonProperty(value="remove_brackets")
    @JsonPropertyDescription(value="When <code>true</code>, the processor also removes brackets around the indices. Can only be set to <code>true</code> when <code>remove_list_indices</code> is <code>true</code>.")
    @AlsoRequired(values={@AlsoRequired.Required(name="remove_list_indices", allowedValues={"true"})})
    private boolean removeBrackets = false;
    @JsonProperty(value="exclude_keys")
    @JsonPropertyDescription(value="The keys from the source field that should be excluded from processing. By default no keys are excluded.")
    private List<String> excludeKeys = DEFAULT_EXCLUDE_KEYS;
    @JsonProperty(value="tags_on_failure")
    @JsonPropertyDescription(value="A list of tags to add to the event metadata when the event fails to process.")
    private List<String> tagsOnFailure;
    @JsonProperty(value="flatten_when")
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a> such as <code>/some_key == \"test\"</code>. If specified, the <code>flatten</code> processor will only run on events when the expression evaluates to true. ")
    @ExampleValues(value={@ExampleValues.Example(value="/some-key == \"test\"", description="The flatten operation will run when the value of the key is 'test'.")})
    private String flattenWhen;

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isRemoveProcessedFields() {
        return this.removeProcessedFields;
    }

    public boolean isRemoveListIndices() {
        return this.removeListIndices;
    }

    public boolean isRemoveBrackets() {
        return this.removeBrackets;
    }

    public List<String> getExcludeKeys() {
        return this.excludeKeys;
    }

    public String getFlattenWhen() {
        return this.flattenWhen;
    }

    public List<String> getTagsOnFailure() {
        return this.tagsOnFailure;
    }

    @AssertTrue(message="remove_brackets can not be true if remove_list_indices is false.")
    @AssertTrue(message="remove_brackets can not be true if remove_list_indices is false.") boolean removeBracketsNotTrueWhenRemoveListIndicesFalse() {
        return !this.removeBrackets || this.removeListIndices;
    }
}

