/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.flatten;

import com.github.wnameless.json.flattener.JsonFlattener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.flatten.FlattenProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="flatten", pluginType=Processor.class, pluginConfigurationType=FlattenProcessorConfig.class)
public class FlattenProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(FlattenProcessor.class);
    private static final String SEPARATOR = "/";
    private final FlattenProcessorConfig config;
    private final ExpressionEvaluator expressionEvaluator;
    private final Map<String, String> excludeKeysAndJsonPointers = new HashMap<String, String>();

    @DataPrepperPluginConstructor
    public FlattenProcessor(PluginMetrics pluginMetrics, FlattenProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.config = config;
        this.expressionEvaluator = expressionEvaluator;
        for (String key : config.getExcludeKeys()) {
            this.excludeKeysAndJsonPointers.put(key, this.getJsonPointer(config.getSource(), key));
        }
        if (config.getFlattenWhen() != null && !expressionEvaluator.isValidExpressionStatement(config.getFlattenWhen()).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("flatten_when \"%s\" is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", config.getFlattenWhen()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            String keyInEvent;
            HashMap<String, Object> excludeMap;
            Event recordEvent;
            block14: {
                recordEvent = (Event)record.getData();
                excludeMap = new HashMap<String, Object>();
                if (this.config.getFlattenWhen() == null || this.expressionEvaluator.evaluateConditional(this.config.getFlattenWhen(), recordEvent).booleanValue()) break block14;
                for (String key : excludeMap.keySet()) {
                    keyInEvent = this.excludeKeysAndJsonPointers.get(key);
                    recordEvent.put(keyInEvent, excludeMap.get(key));
                }
                continue;
            }
            try {
                for (String key : this.excludeKeysAndJsonPointers.keySet()) {
                    keyInEvent = this.excludeKeysAndJsonPointers.get(key);
                    if (!recordEvent.containsKey(keyInEvent)) continue;
                    excludeMap.put(key, recordEvent.get(keyInEvent, Object.class));
                    recordEvent.delete(keyInEvent);
                }
                String sourceJson = recordEvent.getAsJsonString(this.config.getSource());
                Map<String, Object> flattenedJson = new JsonFlattener(sourceJson).ignoreReservedCharacters().flattenAsMap();
                if (this.config.isRemoveProcessedFields()) {
                    Map sourceMap = (Map)recordEvent.get(this.config.getSource(), Map.class);
                    for (String keyInSource : sourceMap.keySet()) {
                        recordEvent.delete(this.getJsonPointer(this.config.getSource(), keyInSource));
                    }
                }
                if (this.config.isRemoveListIndices()) {
                    flattenedJson = this.removeListIndicesInKeys(flattenedJson);
                }
                this.updateEvent(recordEvent, flattenedJson);
            }
            catch (Exception e) {
                try {
                    LOG.error(DataPrepperMarkers.NOISY, "Fail to perform flatten operation", (Throwable)e);
                    recordEvent.getMetadata().addTags(this.config.getTagsOnFailure());
                }
                catch (Throwable throwable) {
                    for (String key : excludeMap.keySet()) {
                        String keyInEvent2 = this.excludeKeysAndJsonPointers.get(key);
                        recordEvent.put(keyInEvent2, excludeMap.get(key));
                    }
                    throw throwable;
                }
                for (String key : excludeMap.keySet()) {
                    keyInEvent = this.excludeKeysAndJsonPointers.get(key);
                    recordEvent.put(keyInEvent, excludeMap.get(key));
                }
                continue;
            }
            for (String key : excludeMap.keySet()) {
                keyInEvent = this.excludeKeysAndJsonPointers.get(key);
                recordEvent.put(keyInEvent, excludeMap.get(key));
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    private String getJsonPointer(String outerKey, String innerKey) {
        if (outerKey.isEmpty()) {
            return SEPARATOR + innerKey;
        }
        return SEPARATOR + outerKey + SEPARATOR + innerKey;
    }

    private Map<String, Object> removeListIndicesInKeys(Map<String, Object> inputMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : inputMap.entrySet()) {
            String keyWithoutIndices = this.removeListIndices(entry.getKey(), this.config.isRemoveBrackets());
            this.addFieldsToMapWithMerge(keyWithoutIndices, entry.getValue(), resultMap);
        }
        return resultMap;
    }

    private String removeListIndices(String key, boolean removeBrackets) {
        String replacement = removeBrackets ? "" : "[]";
        return key.replaceAll("\\[\\d+\\]", replacement);
    }

    private void addFieldsToMapWithMerge(String key, Object value, Map<String, Object> map) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        } else {
            Object currentValue = map.get(key);
            if (currentValue instanceof List) {
                ((List)currentValue).add(value);
            } else {
                ArrayList<Object> newValue = new ArrayList<Object>();
                newValue.add(currentValue);
                newValue.add(value);
                map.put(key, newValue);
            }
        }
    }

    private void updateEvent(Event recordEvent, Map<String, Object> flattenedJson) {
        if (this.config.getTarget().isEmpty()) {
            for (Map.Entry<String, Object> entry : flattenedJson.entrySet()) {
                recordEvent.put(entry.getKey(), entry.getValue());
            }
        } else {
            recordEvent.put(this.config.getTarget(), flattenedJson);
        }
    }
}

