/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.dlq.s3;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.opensearch.dataprepper.aws.validator.AwsAccountId;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class S3DlqWriterConfig {
    private static final int MAX_NUMBER_OF_RETRIES = 3;
    private static final String DEFAULT_AWS_REGION = "us-east-1";
    private static final String AWS_IAM_ROLE = "role";
    private static final String AWS_IAM = "iam";
    private static final String S3_PREFIX = "s3://";
    @JsonProperty(value="bucket")
    @NotEmpty
    @Size(min=3, max=500, message="bucket length should be at least 3 characters")
    private @NotEmpty @Size(min=3, max=500, message="bucket length should be at least 3 characters") String bucket;
    @JsonProperty(value="key_path_prefix")
    @Size(min=1, max=1024, message="key_path_prefix length should be between 1 and 1024 characters")
    private @Size(min=1, max=1024, message="key_path_prefix length should be between 1 and 1024 characters") String keyPathPrefix;
    @JsonProperty(value="region")
    @Size(min=1, message="region cannot be empty string")
    private @Size(min=1, message="region cannot be empty string") String region = "us-east-1";
    @JsonProperty(value="sts_role_arn")
    @Size(min=20, max=2048, message="sts_role_arn length should be between 1 and 2048 characters")
    private @Size(min=20, max=2048, message="sts_role_arn length should be between 1 and 2048 characters") String stsRoleArn;
    @JsonProperty(value="sts_external_id")
    @Size(min=2, max=1224, message="sts_external_id length should be between 2 and 1224 characters")
    private @Size(min=2, max=1224, message="sts_external_id length should be between 2 and 1224 characters") String stsExternalId;
    @JsonProperty(value="sts_header_overrides")
    private Map<String, String> stsHeaderOverrides;
    @JsonProperty(value="bucket_owner")
    @AwsAccountId
    private String bucketOwner;

    public String getBucket() {
        if (this.bucket.startsWith(S3_PREFIX)) {
            return this.bucket.substring(S3_PREFIX.length());
        }
        return this.bucket;
    }

    public String getKeyPathPrefix() {
        return this.keyPathPrefix;
    }

    public Region getRegion() {
        return Region.of((String)this.region);
    }

    public String getBucketOwner() {
        return this.bucketOwner;
    }

    private AwsCredentialsProvider getAwsCredentialsProvider() {
        if (this.stsRoleArn == null || this.stsRoleArn.isEmpty()) {
            return DefaultCredentialsProvider.create();
        }
        this.validateStsRoleArn();
        StsClient stsClient = (StsClient)((StsClientBuilder)StsClient.builder().region(this.getRegion())).build();
        AssumeRoleRequest.Builder assumeRoleRequestBuilder = AssumeRoleRequest.builder().roleSessionName("s3-dlq-" + String.valueOf(UUID.randomUUID())).roleArn(this.stsRoleArn);
        if (this.stsExternalId != null && !this.stsExternalId.isEmpty()) {
            assumeRoleRequestBuilder = assumeRoleRequestBuilder.externalId(this.stsExternalId);
        }
        if (this.stsHeaderOverrides != null && !this.stsHeaderOverrides.isEmpty()) {
            assumeRoleRequestBuilder = assumeRoleRequestBuilder.overrideConfiguration(configuration -> this.stsHeaderOverrides.forEach((arg_0, arg_1) -> ((AwsRequestOverrideConfiguration.Builder)configuration).putHeader(arg_0, arg_1)));
        }
        return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)assumeRoleRequestBuilder.build()).build();
    }

    private void validateStsRoleArn() {
        Arn arn = this.getArn();
        if (!AWS_IAM.equals(arn.service())) {
            throw new IllegalArgumentException("sts_role_arn must be an IAM Role");
        }
        Optional resourceType = arn.resource().resourceType();
        if (resourceType.isEmpty() || !((String)resourceType.get()).equals(AWS_IAM_ROLE)) {
            throw new IllegalArgumentException("sts_role_arn must be an IAM Role");
        }
    }

    private Arn getArn() {
        try {
            return Arn.fromString((String)this.stsRoleArn);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid ARN format for sts_role_arn");
        }
    }

    public S3Client getS3Client() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(this.getRegion())).credentialsProvider(this.getAwsCredentialsProvider())).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(RetryPolicy.builder().numRetries(Integer.valueOf(3)).build()).build())).build();
    }
}

