/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.dlq;

import io.micrometer.core.instrument.Counter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.failures.DlqObject;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.plugins.dlq.DlqProvider;
import org.opensearch.dataprepper.plugins.dlq.DlqWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlqPushHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DlqPushHandler.class);
    public static final String NUM_DLQ_SUCCESS = "NumDlqSuccess";
    public static final String NUM_DLQ_FAILED = "NumDlqFailed";
    public static final String STS_ROLE_ARN = "sts_role_arn";
    public static final String REGION = "region";
    private final DlqProvider dlqProvider;
    private final PluginSetting dlqPluginSetting;
    private final DlqWriter dlqWriter;
    private final Counter dlqSuccessCounter;
    private final Counter dlqFailedCounter;

    public DlqPushHandler(PluginFactory pluginFactory, PluginSetting pluginSetting, PluginMetrics pluginMetrics, PluginModel dlqConfig, String region, String role, String metricsPrefix) {
        Optional<DlqWriter> potentialDlq;
        Map dlqSettings = dlqConfig.getPluginSettings();
        if (!dlqSettings.containsKey(REGION) && region != null) {
            dlqSettings.put(REGION, region);
        }
        if (!dlqSettings.containsKey(STS_ROLE_ARN) && role != null) {
            dlqSettings.put(STS_ROLE_ARN, role);
        }
        this.dlqPluginSetting = new PluginSetting(dlqConfig.getPluginName(), dlqSettings);
        this.dlqPluginSetting.setPipelineName(pluginSetting.getPipelineName());
        this.dlqProvider = (DlqProvider)pluginFactory.loadPlugin(DlqProvider.class, this.dlqPluginSetting, new Object[0]);
        this.dlqWriter = this.dlqProvider != null ? ((potentialDlq = this.dlqProvider.getDlqWriter(new StringJoiner(".").add(pluginSetting.getPipelineName()).add(pluginSetting.getName()).toString())).isPresent() ? potentialDlq.get() : null) : null;
        this.dlqSuccessCounter = pluginMetrics.counter(metricsPrefix + NUM_DLQ_SUCCESS);
        this.dlqFailedCounter = pluginMetrics.counter(metricsPrefix + NUM_DLQ_FAILED);
    }

    public PluginSetting getPluginSetting() {
        return this.dlqPluginSetting;
    }

    public double getDlqSuccessCounter() {
        return this.dlqSuccessCounter.count();
    }

    public double getDlqFailedCounter() {
        return this.dlqFailedCounter.count();
    }

    public boolean perform(List<DlqObject> dlqObjects) {
        try {
            if (this.dlqWriter != null && dlqObjects != null && dlqObjects.size() > 0) {
                this.dlqWriter.write(dlqObjects, this.dlqPluginSetting.getPipelineName(), this.dlqPluginSetting.getName());
                this.dlqSuccessCounter.increment((double)dlqObjects.size());
                return true;
            }
        }
        catch (Exception e) {
            LOG.error(DataPrepperMarkers.NOISY, "failed to write to DLQ", (Throwable)e);
            this.dlqFailedCounter.increment((double)dlqObjects.size());
        }
        return false;
    }
}

