/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.encryption;

import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.encryption.EncryptedDataKeyWriterFactory;
import org.opensearch.dataprepper.plugins.encryption.EncryptionEngineConfiguration;
import org.opensearch.dataprepper.plugins.encryption.EncryptionRotationHandler;
import org.opensearch.dataprepper.plugins.encryption.KmsEncryptionEngineConfiguration;
import org.opensearch.dataprepper.plugins.encryption.KmsEncryptionRotationHandler;
import org.opensearch.dataprepper.plugins.encryption.LocalDirectoryEncryptedDataKeyWriter;
import org.opensearch.dataprepper.plugins.encryption.S3EncryptedDataKeyWriter;
import software.amazon.awssdk.services.s3.S3Client;

class EncryptionRotationHandlerFactory {
    private final PluginMetrics pluginMetrics;
    private final EncryptedDataKeyWriterFactory encryptedDataKeyWriterFactory;

    public static EncryptionRotationHandlerFactory create(PluginMetrics pluginMetrics, EncryptedDataKeyWriterFactory encryptedDataKeyWriterFactory) {
        return new EncryptionRotationHandlerFactory(pluginMetrics, encryptedDataKeyWriterFactory);
    }

    private EncryptionRotationHandlerFactory(PluginMetrics pluginMetrics, EncryptedDataKeyWriterFactory encryptedDataKeyWriterFactory) {
        this.pluginMetrics = pluginMetrics;
        this.encryptedDataKeyWriterFactory = encryptedDataKeyWriterFactory;
    }

    public EncryptionRotationHandler createEncryptionRotationHandler(String encryptionId, EncryptionEngineConfiguration encryptionEngineConfiguration) {
        if (encryptionEngineConfiguration instanceof KmsEncryptionEngineConfiguration) {
            return this.createKmsEncryptionRotationHandler(encryptionId, (KmsEncryptionEngineConfiguration)encryptionEngineConfiguration);
        }
        throw new IllegalArgumentException("Unsupported encryption engine configuration for creating rotation handler.");
    }

    private KmsEncryptionRotationHandler createKmsEncryptionRotationHandler(String encryptionId, KmsEncryptionEngineConfiguration kmsEncryptionEngineConfiguration) {
        if (kmsEncryptionEngineConfiguration.isEncryptionKeyInS3()) {
            S3Client s3Client = kmsEncryptionEngineConfiguration.createS3Client();
            S3EncryptedDataKeyWriter encryptedDataKeyWriter = this.encryptedDataKeyWriterFactory.createS3EncryptedDataKeyWriter(s3Client, kmsEncryptionEngineConfiguration.getEncryptionKeyDirectory());
            return new KmsEncryptionRotationHandler(encryptionId, kmsEncryptionEngineConfiguration, encryptedDataKeyWriter, this.pluginMetrics);
        }
        LocalDirectoryEncryptedDataKeyWriter encryptedDataKeyWriter = this.encryptedDataKeyWriterFactory.createLocalDirectoryEncryptedDataKeyWriter(kmsEncryptionEngineConfiguration.getEncryptionKeyDirectory());
        return new KmsEncryptionRotationHandler(encryptionId, kmsEncryptionEngineConfiguration, encryptedDataKeyWriter, this.pluginMetrics);
    }
}

