/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.model;

import java.time.Duration;
import java.time.Instant;

public class ShardCheckpointStatus {
    private final String sequenceNumber;
    private final boolean isFinalAcknowledgmentForPartition;
    private AcknowledgmentStatus acknowledgeStatus;
    private final long createTimestamp;
    private Long acknowledgedTimestamp;

    public ShardCheckpointStatus(String sequenceNumber, long createTimestamp, boolean isFinalAcknowledgmentForPartition) {
        this.sequenceNumber = sequenceNumber;
        this.acknowledgeStatus = AcknowledgmentStatus.NO_ACK;
        this.createTimestamp = createTimestamp;
        this.isFinalAcknowledgmentForPartition = isFinalAcknowledgmentForPartition;
    }

    public void setAcknowledgedTimestamp(Long acknowledgedTimestamp) {
        this.acknowledgedTimestamp = acknowledgedTimestamp;
    }

    public void setAcknowledged(AcknowledgmentStatus acknowledgmentStatus) {
        this.acknowledgeStatus = acknowledgmentStatus;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean isPositiveAcknowledgement() {
        return this.acknowledgeStatus == AcknowledgmentStatus.POSITIVE_ACK;
    }

    public boolean isNegativeAcknowledgement() {
        return this.acknowledgeStatus == AcknowledgmentStatus.NEGATIVE_ACK;
    }

    public boolean isFinalAcknowledgmentForPartition() {
        return this.isFinalAcknowledgmentForPartition;
    }

    public boolean isExpired(Duration expiredDuration) {
        return Duration.between(Instant.ofEpochMilli(this.createTimestamp), Instant.now()).compareTo(expiredDuration) > 0;
    }

    public static enum AcknowledgmentStatus {
        POSITIVE_ACK,
        NEGATIVE_ACK,
        NO_ACK;

    }
}

