/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.coordination;

import java.util.function.Function;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.dynamodb.coordination.partition.DataFilePartition;
import org.opensearch.dataprepper.plugins.source.dynamodb.coordination.partition.ExportPartition;
import org.opensearch.dataprepper.plugins.source.dynamodb.coordination.partition.GlobalState;
import org.opensearch.dataprepper.plugins.source.dynamodb.coordination.partition.LeaderPartition;
import org.opensearch.dataprepper.plugins.source.dynamodb.coordination.partition.StreamPartition;

public class PartitionFactory
implements Function<SourcePartitionStoreItem, EnhancedSourcePartition> {
    @Override
    public EnhancedSourcePartition apply(SourcePartitionStoreItem partitionStoreItem) {
        String sourceIdentifier = partitionStoreItem.getSourceIdentifier();
        String partitionType = sourceIdentifier.substring(sourceIdentifier.lastIndexOf(124) + 1);
        if ("EXPORT".equals(partitionType)) {
            return new ExportPartition(partitionStoreItem);
        }
        if ("STREAM".equals(partitionType)) {
            return new StreamPartition(partitionStoreItem);
        }
        if ("DATAFILE".equals(partitionType)) {
            return new DataFilePartition(partitionStoreItem);
        }
        if ("LEADER".equals(partitionType)) {
            return new LeaderPartition(partitionStoreItem);
        }
        return new GlobalState(partitionStoreItem);
    }
}

