/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.dissect.Fields;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.AppendField;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.Field;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.IndirectField;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.NormalField;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.SkipField;

public class FieldHelper {
    private final Pattern appendPattern = Pattern.compile("^(.*?)->");
    private final Pattern prefixPattern = Pattern.compile("([+&?])(.+)");
    private final Pattern indexPattern = Pattern.compile("/(\\d+)$");
    private final Map<String, SkipField> skipFieldMap = new HashMap<String, SkipField>();
    private final Map<String, NormalField> normalFieldMap = new HashMap<String, NormalField>();
    private final Map<String, IndirectField> indirectFieldMap = new HashMap<String, IndirectField>();
    private final Map<String, List<AppendField>> appendFieldMap = new HashMap<String, List<AppendField>>();

    public Map<String, SkipField> getSkipFieldMap() {
        return this.skipFieldMap;
    }

    public Map<String, NormalField> getNormalFieldMap() {
        return this.normalFieldMap;
    }

    public Map<String, IndirectField> getIndirectFieldMap() {
        return this.indirectFieldMap;
    }

    public Map<String, List<AppendField>> getAppendFieldMap() {
        return this.appendFieldMap;
    }

    public Field getField(String fieldString) {
        if (fieldString == null) {
            return null;
        }
        if (fieldString.trim().isEmpty()) {
            return new AppendField("");
        }
        Field field = null;
        Matcher matcher = this.prefixPattern.matcher(fieldString);
        if (matcher.matches()) {
            String notation = matcher.group(1);
            String key = matcher.group(2);
            if (Objects.equals(notation, "+")) {
                field = new AppendField(key);
                this.setAppendIndex((AppendField)field);
                this.setStripTrailing(field);
                this.putInAppendMap((AppendField)field);
            } else if (Objects.equals(notation, "?")) {
                field = new SkipField(key);
                this.setStripTrailing(field);
                this.skipFieldMap.put(field.getKey(), (SkipField)field);
            } else if (Objects.equals(notation, "&")) {
                field = new IndirectField(key);
                this.setStripTrailing(field);
                this.indirectFieldMap.put(field.getKey(), (IndirectField)field);
            }
        } else {
            field = new NormalField(fieldString);
            this.setStripTrailing(field);
            this.normalFieldMap.put(field.getKey(), (NormalField)field);
        }
        return field;
    }

    private void setAppendIndex(AppendField field) {
        String fieldString = field.getKey();
        Matcher matcher = this.indexPattern.matcher(fieldString);
        if (matcher.find()) {
            String key = fieldString.substring(0, matcher.start());
            int index = Integer.parseInt(matcher.group(1));
            field.setKey(key);
            field.setIndex(index);
        }
    }

    private void setStripTrailing(Field field) {
        if (field == null) {
            return;
        }
        String fieldString = field.getKey();
        Matcher matcher = this.appendPattern.matcher(fieldString);
        if (matcher.find()) {
            field.setKey(matcher.group(1));
            field.stripTrailing = true;
        }
    }

    private void putInAppendMap(AppendField field) {
        String key = field.getKey();
        if (this.appendFieldMap.containsKey(key)) {
            this.appendFieldMap.get(key).add(field);
        } else {
            ArrayList<AppendField> appendFields = new ArrayList<AppendField>();
            appendFields.add(field);
            this.appendFieldMap.put(key, appendFields);
        }
    }
}

