/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.decompress.encoding;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.plugins.processor.decompress.encoding.Base64DecoderEngine;
import org.opensearch.dataprepper.plugins.processor.decompress.encoding.DecoderEngine;
import org.opensearch.dataprepper.plugins.processor.decompress.encoding.DecoderEngineFactory;

public enum EncodingType implements DecoderEngineFactory
{
    BASE64("base64");

    private final String option;
    private static final Map<String, EncodingType> OPTIONS_MAP;
    private static final Map<String, DecoderEngine> DECODER_ENGINE_MAP;

    private EncodingType(String option) {
        this.option = option;
    }

    @JsonCreator
    static EncodingType fromOptionValue(String option) {
        return OPTIONS_MAP.get(option);
    }

    @Override
    public DecoderEngine getDecoderEngine() {
        return DECODER_ENGINE_MAP.get(this.option);
    }

    static {
        OPTIONS_MAP = Arrays.stream(EncodingType.values()).collect(Collectors.toMap(value -> value.option, value -> value));
        DECODER_ENGINE_MAP = Map.of("base64", new Base64DecoderEngine());
    }
}

