/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.csv;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import java.util.List;
import java.util.Objects;

public class CsvInputCodecConfig {
    static final String DEFAULT_DELIMITER = ",";
    static final String DEFAULT_QUOTE_CHARACTER = "\"";
    static final Boolean DEFAULT_DETECT_HEADER = true;
    @JsonProperty(value="delimiter")
    private String delimiter = ",";
    @JsonProperty(value="quote_character")
    private String quoteCharacter = "\"";
    @JsonProperty(value="header")
    private List<String> header;
    @JsonProperty(value="detect_header")
    private Boolean detectHeader = DEFAULT_DETECT_HEADER;

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public Boolean isDetectHeader() {
        return this.detectHeader;
    }

    @AssertTrue(message="delimiter must be exactly one character.")
    @AssertTrue(message="delimiter must be exactly one character.") boolean isValidDelimiter() {
        return this.delimiter.length() == 1;
    }

    @AssertTrue(message="quote_character must be exactly one character.")
    @AssertTrue(message="quote_character must be exactly one character.") boolean isValidQuoteCharacter() {
        return this.quoteCharacter.length() == 1;
    }

    @AssertTrue(message="quote_character and delimiter cannot be the same character.")
    @AssertTrue(message="quote_character and delimiter cannot be the same character.") boolean areDelimiterAndQuoteCharacterDifferent() {
        return !this.delimiter.equals(this.quoteCharacter);
    }

    @AssertTrue(message="header must not be an empty list. To autogenerate columns, set detect_header: false and delete header from config.")
    @AssertTrue(message="header must not be an empty list. To autogenerate columns, set detect_header: false and delete header from config.") boolean isValidHeader() {
        return Objects.isNull(this.header) || this.header.size() > 0;
    }
}

