/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.csv;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.plugins.codec.csv.CsvHeaderParser;
import org.opensearch.dataprepper.plugins.codec.csv.CsvHeaderParserFromS3;
import org.opensearch.dataprepper.plugins.codec.csv.CsvOutputCodecConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="csv", pluginType=OutputCodec.class, pluginConfigurationType=CsvOutputCodecConfig.class)
public class CsvOutputCodec
implements OutputCodec {
    private final CsvOutputCodecConfig config;
    private static final Logger LOG = LoggerFactory.getLogger(CsvOutputCodec.class);
    private static final String CSV = "csv";
    private static final String DELIMITER = ",";
    private int headerLength = 0;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private List<String> headerList;
    private OutputCodecContext codecContext;

    @DataPrepperPluginConstructor
    public CsvOutputCodec(CsvOutputCodecConfig config) {
        Objects.requireNonNull(config);
        this.config = config;
    }

    public void start(OutputStream outputStream, Event event, OutputCodecContext codecContext) throws IOException {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(codecContext);
        this.codecContext = codecContext;
        if (this.config.getHeader() != null) {
            this.headerList = this.config.getHeader();
        } else if (this.config.getHeaderFileLocation() != null) {
            try {
                this.headerList = CsvHeaderParser.headerParser(this.config.getHeaderFileLocation());
            }
            catch (Exception e) {
                LOG.error("Unable to parse CSV Header, Error:{} ", (Object)e.getMessage());
                throw new IOException("Unable to parse CSV Header.");
            }
        } else if (this.checkS3HeaderValidity()) {
            this.headerList = CsvHeaderParserFromS3.parseHeader(this.config);
        } else {
            LOG.error("No header provided.");
            throw new IOException("No header found. Can't proceed without header.");
        }
        this.headerLength = this.headerList.size();
        byte[] byteArr = String.join((CharSequence)this.config.getDelimiter(), this.headerList).getBytes();
        this.writeToOutputStream(outputStream, byteArr);
    }

    public void complete(OutputStream outputStream) throws IOException {
        outputStream.close();
    }

    public void writeEvent(Event event, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(event);
        Map eventMap = this.codecContext.getTagsTargetKey() != null ? this.addTagsToEvent(event, this.codecContext.getTagsTargetKey()).toMap() : event.toMap();
        if (!this.codecContext.getExcludeKeys().isEmpty()) {
            for (String string : this.codecContext.getExcludeKeys()) {
                eventMap.remove(string);
            }
        }
        for (Map.Entry entry : eventMap.entrySet()) {
            Object mapValue = entry.getValue();
            entry.setValue(objectMapper.writeValueAsString(mapValue));
        }
        List valueList = eventMap.entrySet().stream().map(map -> map.getValue().toString()).collect(Collectors.toList());
        if (this.headerLength != valueList.size()) {
            LOG.error("CSV Row doesn't conform with the header.");
            return;
        }
        byte[] byArray = valueList.stream().collect(Collectors.joining(DELIMITER)).getBytes();
        this.writeToOutputStream(outputStream, byArray);
    }

    private void writeToOutputStream(OutputStream outputStream, byte[] byteArr) throws IOException {
        outputStream.write(byteArr);
        outputStream.write(System.lineSeparator().getBytes());
    }

    public String getExtension() {
        return CSV;
    }

    private boolean checkS3HeaderValidity() throws IOException {
        if (this.config.getBucketName() != null && this.config.getFile_key() != null && this.config.getRegion() != null) {
            return true;
        }
        LOG.error("Invalid S3 credentials, can't reach the header file.");
        throw new IOException("Can't proceed without header.");
    }
}

