/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.csv;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvReadException;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventFactory;
import org.opensearch.dataprepper.model.event.LogEventBuilder;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.codec.csv.CsvInputCodecConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="csv", pluginType=InputCodec.class, pluginConfigurationType=CsvInputCodecConfig.class)
public class CsvInputCodec
implements InputCodec {
    private static final Logger LOG = LoggerFactory.getLogger(CsvInputCodec.class);
    private final CsvInputCodecConfig config;
    private final EventFactory eventFactory;

    @DataPrepperPluginConstructor
    public CsvInputCodec(CsvInputCodecConfig config, EventFactory eventFactory) {
        Objects.requireNonNull(config);
        this.config = config;
        this.eventFactory = eventFactory;
    }

    public void parse(InputStream inputStream, Consumer<Record<Event>> eventConsumer) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            this.parseBufferedReader(reader, eventConsumer);
        }
    }

    private void parseBufferedReader(BufferedReader reader, Consumer<Record<Event>> eventConsumer) throws IOException {
        boolean hasNextValue;
        CsvSchema schema;
        CsvMapper mapper = this.createCsvMapper();
        if (this.config.isDetectHeader().booleanValue()) {
            schema = this.createAutodetectHeaderCsvSchema();
        } else {
            int numberColumnsFirstLine = this.getNumberOfColumnsByMarkingBeginningOfInputStreamAndResettingReaderAfter(reader);
            schema = this.createCsvSchemaFromConfig(numberColumnsFirstLine);
        }
        MappingIterator parsingIterator = mapper.readerFor(Map.class).with((FormatSchema)schema).readValues((Reader)reader);
        try {
            hasNextValue = parsingIterator.hasNextValue();
        }
        catch (Exception ex) {
            LOG.error("An Exception occurred while determining if file has next line ", (Throwable)ex);
            throw ex;
        }
        while (hasNextValue) {
            this.readCsvLine((MappingIterator<Map<String, String>>)parsingIterator, eventConsumer);
            try {
                hasNextValue = parsingIterator.hasNextValue();
            }
            catch (Exception ex) {
                LOG.error("An Exception occurred while determining if file has next line ", (Throwable)ex);
                throw ex;
            }
        }
    }

    private int getNumberOfColumnsByMarkingBeginningOfInputStreamAndResettingReaderAfter(BufferedReader reader) throws IOException {
        int defaultBufferSize = 8192;
        reader.mark(8192);
        int firstLineNumberColumns = this.extractNumberOfColumnsFromFirstLine(reader.readLine());
        reader.reset();
        return firstLineNumberColumns;
    }

    private void readCsvLine(MappingIterator<Map<String, String>> parsingIterator, Consumer<Record<Event>> eventConsumer) throws IOException {
        try {
            Map parsedLine = (Map)parsingIterator.nextValue();
            Event event = ((LogEventBuilder)this.eventFactory.eventBuilder(LogEventBuilder.class)).withData((Object)parsedLine).build();
            eventConsumer.accept((Record<Event>)new Record((Object)event));
        }
        catch (CsvReadException csvException) {
            LOG.error("Invalid CSV row, skipping this line. This typically means the row has too many columns. Consider using the CSV Processor if there might be inconsistencies in the number of columns because it is more flexible. Error: {}. Line Number: {} Character Number: {}", new Object[]{csvException.getMessage(), parsingIterator.getCurrentLocation().getLineNr(), parsingIterator.getCurrentLocation().getColumnNr()});
            throw csvException;
        }
        catch (JsonParseException jsonException) {
            LOG.error("A JsonParseException occurred on a row of the CSV file, skipping line. This typically means a quote character was not properly closed. Error: {}", (Object)jsonException.getMessage());
            throw jsonException;
        }
        catch (Exception e) {
            LOG.error("An Exception occurred while reading a row of the CSV file. Error ", (Throwable)e);
            throw e;
        }
    }

    private int extractNumberOfColumnsFromFirstLine(String firstLine) {
        if (Objects.isNull(firstLine)) {
            return 0;
        }
        int numberOfSeparators = 0;
        for (int charPointer = 0; charPointer < firstLine.length(); ++charPointer) {
            if (firstLine.charAt(charPointer) != this.config.getDelimiter().charAt(0)) continue;
            ++numberOfSeparators;
        }
        return numberOfSeparators + 1;
    }

    private CsvSchema createCsvSchemaFromConfig(int firstLineSize) {
        List<Object> userSpecifiedHeader = Objects.isNull(this.config.getHeader()) ? new ArrayList() : this.config.getHeader();
        ArrayList<String> actualHeader = new ArrayList<String>();
        char delimiter = this.config.getDelimiter().charAt(0);
        char quoteCharacter = this.config.getQuoteCharacter().charAt(0);
        for (int providedHeaderColIdx = 0; providedHeaderColIdx < userSpecifiedHeader.size() && providedHeaderColIdx < firstLineSize; ++providedHeaderColIdx) {
            actualHeader.add((String)userSpecifiedHeader.get(providedHeaderColIdx));
        }
        for (int remainingColIdx = providedHeaderColIdx; remainingColIdx < firstLineSize; ++remainingColIdx) {
            actualHeader.add(this.generateColumnHeader(remainingColIdx));
        }
        CsvSchema.Builder headerBuilder = CsvSchema.builder();
        for (String columnName : actualHeader) {
            headerBuilder = headerBuilder.addColumn(columnName);
        }
        CsvSchema schema = headerBuilder.build().withColumnSeparator(delimiter).withQuoteChar(quoteCharacter);
        return schema;
    }

    private String generateColumnHeader(int columnNumber) {
        int displayColumnNumber = columnNumber + 1;
        return "column" + displayColumnNumber;
    }

    private CsvMapper createCsvMapper() {
        CsvMapper mapper = new CsvMapper();
        return mapper;
    }

    private CsvSchema createAutodetectHeaderCsvSchema() {
        CsvSchema schema = CsvSchema.emptySchema().withColumnSeparator(this.config.getDelimiter().charAt(0)).withQuoteChar(this.config.getQuoteCharacter().charAt(0)).withHeader();
        return schema;
    }
}

