/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.crowdstrike.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdStrikeNextLinkValidator {
    private static final Logger log = LoggerFactory.getLogger(CrowdStrikeNextLinkValidator.class);
    private static final Set<String> ALLOWED_FILTER_KEYS = Set.of("last_updated", "_marker");
    private static final Pattern FILTER_COMPONENT_PATTERN = Pattern.compile("^([a-z_]+):(>=|<=|>|<)['%a-zA-Z0-9:\\-.]+$");
    private static final Pattern LIMIT_PATTERN = Pattern.compile("^\\d{1,5}$");

    public static String validateAndSanitizeURL(String urlString) throws MalformedURLException {
        String[] pairs;
        URL url = new URL(urlString);
        String query = url.getQuery();
        if (query == null || query.isEmpty()) {
            return urlString;
        }
        HashMap<String, String> validatedParams = new HashMap<String, String>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf(61);
            if (idx <= 0) continue;
            String key = URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8);
            if ("filter".equals(key)) {
                String[] encodedSubFilters;
                ArrayList<String> validSubFilters = new ArrayList<String>();
                String encodedValue = pair.substring(idx + 1);
                for (String encodedSub : encodedSubFilters = encodedValue.split("%2B")) {
                    String sub;
                    try {
                        sub = URLDecoder.decode(encodedSub, StandardCharsets.UTF_8);
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("Invalid URL encoding in subfilter: {}", (Object)encodedSub);
                        continue;
                    }
                    Matcher matcher = FILTER_COMPONENT_PATTERN.matcher(sub);
                    if (matcher.matches()) {
                        String filterKey = sub.substring(0, sub.indexOf(":"));
                        if (ALLOWED_FILTER_KEYS.contains(filterKey)) {
                            validSubFilters.add(sub);
                            continue;
                        }
                        log.warn("Disallowed filter key: {}", (Object)filterKey);
                        continue;
                    }
                    log.warn("Malformed filter segment: {}", (Object)sub);
                }
                if (validSubFilters.isEmpty()) continue;
                validatedParams.put("filter", String.join((CharSequence)"+", validSubFilters));
                continue;
            }
            String value = URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8);
            if ("limit".equals(key) && LIMIT_PATTERN.matcher(value).matches()) {
                validatedParams.put("limit", value);
                continue;
            }
            log.warn("Skipping disallowed or malformed param: {}={}", (Object)key, (Object)value);
        }
        StringBuilder sanitizedURL = new StringBuilder().append(url.getProtocol()).append("://").append(url.getHost());
        if (url.getPort() != -1) {
            sanitizedURL.append(":").append(url.getPort());
        }
        sanitizedURL.append(url.getPath());
        if (!validatedParams.isEmpty()) {
            String queryString = validatedParams.entrySet().stream().map(entry -> URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
            sanitizedURL.append("?").append(queryString);
        }
        return sanitizedURL.toString();
    }
}

