/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.confluence.rest;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Named;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.AtlassianRestClient;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.auth.AtlassianAuthConfig;
import org.opensearch.dataprepper.plugins.source.confluence.models.ConfluencePaginationLinks;
import org.opensearch.dataprepper.plugins.source.confluence.models.ConfluenceSearchResults;
import org.opensearch.dataprepper.plugins.source.confluence.models.ConfluenceServerMetadata;
import org.opensearch.dataprepper.plugins.source.confluence.utils.ConfluenceNextLinkValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Named
public class ConfluenceRestClient
extends AtlassianRestClient {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceRestClient.class);
    public static final String SYSTEM_INFO_API = "wiki/rest/api/settings/systemInfo";
    public static final String REST_API_SEARCH = "wiki/rest/api/content/search";
    public static final String REST_API_FETCH_CONTENT = "wiki/rest/api/content/";
    public static final String REST_API_CONTENT_EXPAND_PARAM = "?expand=body.view";
    public static final String WIKI_PARAM = "wiki";
    public static final String FIFTY = "50";
    public static final String START_AT = "startAt";
    public static final String LIMIT_PARAM = "limit";
    static final String SEARCH_REQUESTS_FAILED = "searchRequestsFailed";
    private static final String PAGE_FETCH_LATENCY_TIMER = "pageFetchLatency";
    private static final String SEARCH_CALL_LATENCY_TIMER = "searchCallLatency";
    private static final String PAGES_REQUESTED = "pagesRequested";
    private static final String PAGE_REQUESTS_FAILED = "pageRequestsFailed";
    private static final String PAGE_REQUESTS_SUCCESS = "pageRequestsSuccess";
    final Counter pageRequestsFailedCounter;
    private final Counter searchRequestsFailedCounter;
    private final RestTemplate restTemplate;
    private final AtlassianAuthConfig authConfig;
    private final Timer contentFetchLatencyTimer;
    private final Timer searchCallLatencyTimer;
    private final Counter contentRequestedCounter;
    private final Counter pageRequestsSuccessCounter;

    public ConfluenceRestClient(RestTemplate restTemplate, AtlassianAuthConfig authConfig, PluginMetrics pluginMetrics) {
        super(restTemplate, authConfig, pluginMetrics);
        this.restTemplate = restTemplate;
        this.authConfig = authConfig;
        this.contentFetchLatencyTimer = pluginMetrics.timer(PAGE_FETCH_LATENCY_TIMER);
        this.searchCallLatencyTimer = pluginMetrics.timer(SEARCH_CALL_LATENCY_TIMER);
        this.contentRequestedCounter = pluginMetrics.counter(PAGES_REQUESTED);
        this.pageRequestsFailedCounter = pluginMetrics.counter(PAGE_REQUESTS_FAILED);
        this.pageRequestsSuccessCounter = pluginMetrics.counter(PAGE_REQUESTS_SUCCESS);
        this.searchRequestsFailedCounter = pluginMetrics.counter(SEARCH_REQUESTS_FAILED);
    }

    public ConfluenceServerMetadata getConfluenceServerMetadata() {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)(this.authConfig.getUrl() + SYSTEM_INFO_API)).buildAndExpand(new Object[0]).toUri();
        return (ConfluenceServerMetadata)this.invokeRestApi(uri, ConfluenceServerMetadata.class).getBody();
    }

    public ConfluenceSearchResults getAllContent(StringBuilder cql, int startAt, ConfluencePaginationLinks paginationLinks) {
        URI uri;
        if (null != paginationLinks && null != paginationLinks.getNext()) {
            try {
                Object urlString = this.authConfig.getUrl() + WIKI_PARAM + paginationLinks.getNext();
                urlString = ConfluenceNextLinkValidator.validateAndSanitizeURL((String)urlString);
                uri = new URI((String)urlString);
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new RuntimeException("Failed to construct pagination url.", e);
            }
        } else {
            uri = UriComponentsBuilder.fromHttpUrl((String)(this.authConfig.getUrl() + REST_API_SEARCH)).queryParam(LIMIT_PARAM, new Object[]{FIFTY}).queryParam(START_AT, new Object[]{startAt}).queryParam("cql", new Object[]{cql}).queryParam("expand", new Object[]{"all,space,history.lastUpdated"}).buildAndExpand(new Object[0]).toUri();
        }
        return (ConfluenceSearchResults)this.searchCallLatencyTimer.record(() -> {
            try {
                return (ConfluenceSearchResults)this.invokeRestApi(uri, ConfluenceSearchResults.class).getBody();
            }
            catch (Exception e) {
                log.error(DataPrepperMarkers.NOISY, "Error while fetching content with cql {}", (Object)cql, (Object)e);
                this.searchRequestsFailedCounter.increment();
                throw e;
            }
        });
    }

    public String getContent(String contentId) {
        this.contentRequestedCounter.increment();
        String url = this.authConfig.getUrl() + "wiki/rest/api/content//" + contentId + REST_API_CONTENT_EXPAND_PARAM;
        URI uri = UriComponentsBuilder.fromHttpUrl((String)url).buildAndExpand(new Object[0]).toUri();
        return (String)this.contentFetchLatencyTimer.record(() -> {
            try {
                String body = (String)this.invokeRestApi(uri, String.class).getBody();
                this.pageRequestsSuccessCounter.increment();
                return body;
            }
            catch (Exception e) {
                log.error("Error while fetching content with id {}", (Object)contentId);
                this.pageRequestsFailedCounter.increment();
                throw e;
            }
        });
    }
}

