/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.common.utils;

import com.linecorp.armeria.client.retry.Backoff;
import java.util.function.Predicate;
import org.slf4j.Logger;

public class RetryUtil {
    private static final long DEFAULT_BASE_DELAY_MS = 100L;
    private static final long DEFAULT_MAX_DELAY_MS = 1000L;
    private static final int DEFAULT_MAX_RETRIES = 3;

    public static boolean retryWithBackoff(Runnable task, Logger log) {
        return RetryUtil.retryWithBackoff(task, 100L, 1000L, 3, log);
    }

    public static boolean retryWithBackoff(Runnable task, long baseDelayMs, long maxDelayMs, int maxRetries, Logger log) {
        RetryResult result = RetryUtil.retryWithBackoffInternal(task, baseDelayMs, maxDelayMs, maxRetries, e -> true, log);
        return result.isSuccess();
    }

    public static RetryResult retryWithBackoffWithResult(Runnable task, Logger log) {
        return RetryUtil.retryWithBackoffInternal(task, 100L, 1000L, 3, e -> true, log);
    }

    private static RetryResult retryWithBackoffInternal(Runnable task, long baseDelayMs, long maxDelayMs, int maxRetries, Predicate<Exception> retryPredicate, Logger log) {
        Backoff backoff = Backoff.exponential((long)baseDelayMs, (long)maxDelayMs).withMaxAttempts(maxRetries);
        int attempt = 1;
        Exception lastException = null;
        while (true) {
            try {
                task.run();
                return new RetryResult(true, null, attempt);
            }
            catch (Exception e) {
                long delayMillis;
                lastException = e;
                if (!retryPredicate.test(e)) {
                    return new RetryResult(false, e, attempt);
                }
                if ((delayMillis = backoff.nextDelayMillis(attempt++)) < 0L) {
                    log.error("Max retries ({}) reached. Last exception: {}", new Object[]{maxRetries, e.getMessage(), e});
                    return new RetryResult(false, e, attempt - 1);
                }
                log.warn("Retry attempt {} failed. Retrying in {} ms... Error: {}", new Object[]{attempt - 1, delayMillis, e.getMessage()});
                try {
                    Thread.sleep(delayMillis);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    log.error("Retry thread interrupted", (Throwable)ie);
                    return new RetryResult(false, ie, attempt - 1);
                }
            }
        }
    }

    public static class RetryResult {
        private final boolean success;
        private final Exception lastException;
        private final int attemptsMade;

        public RetryResult(boolean success, Exception lastException, int attemptsMade) {
            this.success = success;
            this.lastException = lastException;
            this.attemptsMade = attemptsMade;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Exception getLastException() {
            return this.lastException;
        }

        public int getAttemptsMade() {
            return this.attemptsMade;
        }
    }
}

