/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.parquet.io.PositionOutputStream;

public class LocalFilePositionOutputStream
extends PositionOutputStream {
    private final File file;
    private final RandomAccessFile fileStream;
    private boolean closed = false;

    LocalFilePositionOutputStream(File file, RandomAccessFile fileStream) {
        this.file = file;
        this.fileStream = fileStream;
    }

    public static LocalFilePositionOutputStream create(File file) throws IOException {
        return new LocalFilePositionOutputStream(file, new RandomAccessFile(file, "rw"));
    }

    public long getPos() throws IOException {
        if (this.closed) {
            return this.file.length();
        }
        return this.fileStream.getFilePointer();
    }

    public void write(byte[] b) throws IOException {
        this.fileStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.fileStream.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.fileStream.write(b);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.fileStream.close();
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

