/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.certificate.model;

import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.certificate.exception.CertificateFingerprintParsingException;

public class Certificate {
    private static final String SSL_ALGORITHM = "X.509";
    private static final String RSA_ALGORITHM = "SHA-1";
    private String certificate;
    private String privateKey;

    public Certificate(String certificate, String privateKey) {
        this.certificate = Objects.requireNonNull(certificate, "certificate must not be null");
        this.privateKey = Objects.requireNonNull(privateKey, "privateKey must not be null");
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getFingerprint() {
        X509Certificate x509Certificate = this.getX509Certificate();
        return this.convertX509CertificateToFingerprint(x509Certificate);
    }

    private X509Certificate getX509Certificate() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(SSL_ALGORITHM);
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.getCertificate().getBytes(StandardCharsets.UTF_8)));
        }
        catch (CertificateException e) {
            throw new CertificateFingerprintParsingException("Unable to convert certificate to X509Certificate object", e);
        }
    }

    private String convertX509CertificateToFingerprint(X509Certificate x509Certificate) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(RSA_ALGORITHM);
            byte[] derEncodedCertificate = x509Certificate.getEncoded();
            messageDigest.update(derEncodedCertificate);
            byte[] digest = messageDigest.digest();
            return BaseEncoding.base16().lowerCase().encode(digest);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new CertificateFingerprintParsingException("Unable to convert x509Certificate to hexadecimal fingerprint", e);
        }
    }
}

