/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.accumulator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.opensearch.dataprepper.plugins.accumulator.Buffer;

public class InMemoryBuffer
implements Buffer {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private int eventCount = 0;
    private final StopWatch watch = new StopWatch();

    InMemoryBuffer() {
        this.watch.start();
    }

    @Override
    public long getSize() {
        return this.byteArrayOutputStream.size();
    }

    @Override
    public int getEventCount() {
        return this.eventCount;
    }

    @Override
    public long getDuration() {
        return this.watch.getTime(TimeUnit.SECONDS);
    }

    @Override
    public byte[] getSinkBufferData() throws IOException {
        return this.byteArrayOutputStream.toByteArray();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.byteArrayOutputStream;
    }

    @Override
    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }
}

