/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.common.concurrent;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class BackgroundThreadFactory
implements ThreadFactory {
    private final String namePrefix;
    private final ThreadFactory delegateThreadFactory;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    BackgroundThreadFactory(String namePrefix, ThreadFactory delegateThreadFactory) {
        this.namePrefix = Objects.requireNonNull(namePrefix);
        if (namePrefix.isEmpty()) {
            throw new IllegalArgumentException("The thread factory was given an empty namePrefix. It must be provided.");
        }
        this.delegateThreadFactory = Objects.requireNonNull(delegateThreadFactory);
    }

    public static BackgroundThreadFactory defaultExecutorThreadFactory(String namePrefix) {
        return new BackgroundThreadFactory(namePrefix, Executors.defaultThreadFactory());
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this.delegateThreadFactory.newThread(runnable);
        thread.setName(this.namePrefix + "-" + this.threadNumber.getAndIncrement());
        thread.setDaemon(false);
        return thread;
    }
}

