/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.fs;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.apache.parquet.io.SeekableInputStream;

public class LocalInputStream
extends SeekableInputStream {
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private final byte[] page = new byte[8192];
    private final RandomAccessFile input;
    private long markPos = 0L;

    LocalInputStream(RandomAccessFile input) {
        this.input = input;
    }

    public static LocalInputStream create(File file) throws IOException {
        return new LocalInputStream(new RandomAccessFile(file, "r"));
    }

    public int read() throws IOException {
        return this.input.read();
    }

    public int read(byte[] b) throws IOException {
        return this.input.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long savPos = this.input.getFilePointer();
        long amtLeft = this.input.length() - savPos;
        n = Math.min(n, amtLeft);
        long newPos = savPos + n;
        this.input.seek(newPos);
        long curPos = this.input.getFilePointer();
        return curPos - savPos;
    }

    public int available() {
        return 0;
    }

    public void close() throws IOException {
        this.input.close();
    }

    private <T extends Throwable, R> R uncheckedExceptionThrow(Throwable t) throws T {
        throw t;
    }

    public synchronized void mark(int readlimit) {
        try {
            this.markPos = this.input.getFilePointer();
        }
        catch (IOException e) {
            this.uncheckedExceptionThrow(e);
        }
    }

    public long getMarkedPos() {
        return this.markPos;
    }

    public synchronized void reset() throws IOException {
        this.input.seek(this.markPos);
    }

    public boolean markSupported() {
        return true;
    }

    public long getPos() throws IOException {
        return this.input.getFilePointer();
    }

    public void seek(long l) throws IOException {
        this.input.seek(l);
    }

    public void readFully(byte[] bytes) throws IOException {
        this.input.readFully(bytes);
    }

    public void readFully(byte[] bytes, int i, int i1) throws IOException {
        this.input.readFully(bytes, i, i1);
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.readDirectBuffer(byteBuffer, this.page, this.input::read);
    }

    public void readFully(ByteBuffer byteBuffer) throws IOException {
        LocalInputStream.readFullyDirectBuffer(byteBuffer, this.page, this.input::read);
    }

    int readDirectBuffer(ByteBuffer byteBuffer, byte[] page, ByteBufferReader reader) throws IOException {
        int bytesRead;
        int nextReadLength = Math.min(byteBuffer.remaining(), page.length);
        int totalBytesRead = 0;
        while ((bytesRead = reader.read(page, 0, nextReadLength)) == page.length) {
            byteBuffer.put(page);
            totalBytesRead += bytesRead;
            nextReadLength = Math.min(byteBuffer.remaining(), page.length);
        }
        if (bytesRead < 0) {
            return totalBytesRead == 0 ? -1 : totalBytesRead;
        }
        byteBuffer.put(page, 0, bytesRead);
        return totalBytesRead += bytesRead;
    }

    static void readFullyDirectBuffer(ByteBuffer byteBuffer, byte[] page, ByteBufferReader reader) throws IOException {
        int nextReadLength = Math.min(byteBuffer.remaining(), page.length);
        int bytesRead = 0;
        while (nextReadLength > 0 && (bytesRead = reader.read(page, 0, nextReadLength)) >= 0) {
            byteBuffer.put(page, 0, bytesRead);
            nextReadLength = Math.min(byteBuffer.remaining(), page.length);
        }
        if (bytesRead < 0 && byteBuffer.remaining() > 0) {
            throw new EOFException("Reached the end of stream with " + byteBuffer.remaining() + " bytes left to read");
        }
    }

    private static interface ByteBufferReader {
        public int read(byte[] var1, int var2, int var3) throws IOException;
    }
}

