/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.accumulator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.opensearch.dataprepper.plugins.accumulator.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileBuffer
implements Buffer {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileBuffer.class);
    private final OutputStream outputStream;
    private int eventCount;
    private final StopWatch watch;
    private final File localFile;

    LocalFileBuffer(File tempFile) throws FileNotFoundException {
        this.localFile = tempFile;
        this.outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
        this.eventCount = 0;
        this.watch = new StopWatch();
        this.watch.start();
    }

    @Override
    public long getSize() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            LOG.error("An exception occurred while flushing data to buffered output stream :", (Throwable)e);
        }
        return this.localFile.length();
    }

    @Override
    public int getEventCount() {
        return this.eventCount;
    }

    @Override
    public long getDuration() {
        return this.watch.getTime(TimeUnit.SECONDS);
    }

    @Override
    public byte[] getSinkBufferData() throws IOException {
        byte[] fileData = Files.readAllBytes(this.localFile.toPath());
        this.removeTemporaryFile();
        return fileData;
    }

    protected void flushAndCloseStream() {
        try {
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException e) {
            LOG.error("An exception occurred while flushing data to buffered output stream :", (Throwable)e);
        }
    }

    protected void removeTemporaryFile() {
        if (this.localFile != null) {
            try {
                Files.deleteIfExists(Paths.get(this.localFile.toString(), new String[0]));
            }
            catch (IOException e) {
                LOG.error("Unable to delete Local file {}", (Object)this.localFile, (Object)e);
            }
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }
}

