/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink;

import java.util.Collection;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="noop", pluginType=Sink.class)
public class NoopSink
implements Sink<Record<Object>> {
    private static final Logger LOG = LoggerFactory.getLogger(NoopSink.class);

    public void output(Collection<Record<Object>> records) {
        LOG.info("Releasing events for NOOP sink");
        for (Record<Object> record : records) {
            Event event = (Event)record.getData();
            event.getEventHandle().release(true);
        }
    }

    public void shutdown() {
    }

    public void initialize() {
    }

    public boolean isReady() {
        return true;
    }
}

