/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.model.sink.SinkContext;
import org.opensearch.dataprepper.plugins.sink.FileSinkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="file", pluginType=Sink.class, pluginConfigurationType=FileSinkConfig.class)
public class FileSink
implements Sink<Record<Object>> {
    private static final Logger LOG = LoggerFactory.getLogger(FileSink.class);
    private static final String SAMPLE_FILE_PATH = "src/resources/file-test-sample-output.txt";
    public static final String FILE_PATH = "path";
    private final String outputFilePath;
    private BufferedWriter writer;
    private final ReentrantLock lock;
    private boolean isStopRequested;
    private boolean initialized;
    private final String tagsTargetKey;
    private final boolean appendMode;

    @DataPrepperPluginConstructor
    public FileSink(FileSinkConfig fileSinkConfig, SinkContext sinkContext) {
        this.outputFilePath = fileSinkConfig.getPath();
        this.isStopRequested = false;
        this.appendMode = fileSinkConfig.getAppendMode();
        this.initialized = false;
        this.lock = new ReentrantLock(true);
        this.tagsTargetKey = Objects.nonNull(sinkContext) ? sinkContext.getTagsTargetKey() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(Collection<Record<Object>> records) {
        this.lock.lock();
        try {
            if (this.isStopRequested) {
                return;
            }
            for (Record<Object> record : records) {
                try {
                    this.checkTypeAndWriteObject(record.getData(), this.writer);
                }
                catch (IOException ex) {
                    throw new RuntimeException(String.format("Encountered exception writing to file %s", this.outputFilePath), ex);
                }
            }
            try {
                this.writer.flush();
            }
            catch (IOException ex) {
                LOG.warn("Failed to flush for file {}", (Object)this.outputFilePath, (Object)ex);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkTypeAndWriteObject(Object object, BufferedWriter writer) throws IOException {
        if (object instanceof Event) {
            String output = ((Event)object).jsonBuilder().includeTags(this.tagsTargetKey).toJsonString();
            writer.write(output);
            writer.newLine();
            EventHandle eventHandle = ((Event)object).getEventHandle();
            if (eventHandle != null) {
                eventHandle.release(true);
            }
        } else {
            writer.write(object.toString());
            writer.newLine();
        }
    }

    public void shutdown() {
        this.isStopRequested = true;
        this.lock.lock();
        try {
            this.writer.close();
        }
        catch (IOException ex) {
            LOG.error("Failed to close file {}.", (Object)this.outputFilePath, (Object)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initialize() {
        OpenOption[] openOptionArray;
        if (this.appendMode) {
            StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[3];
            standardOpenOptionArray[0] = StandardOpenOption.APPEND;
            standardOpenOptionArray[1] = StandardOpenOption.CREATE;
            openOptionArray = standardOpenOptionArray;
            standardOpenOptionArray[2] = StandardOpenOption.WRITE;
        } else {
            openOptionArray = new StandardOpenOption[]{};
        }
        OpenOption[] openOptions = openOptionArray;
        try {
            this.writer = Files.newBufferedWriter(Paths.get(this.outputFilePath, new String[0]), StandardCharsets.UTF_8, openOptions);
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Encountered exception opening/creating file %s", this.outputFilePath), ex);
        }
        this.initialized = true;
    }

    public boolean isReady() {
        return this.initialized;
    }
}

