/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.certificate.s3;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.model.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;

public class S3CertificateProvider
implements CertificateProvider {
    private static final Logger LOG = LoggerFactory.getLogger(S3CertificateProvider.class);
    private final S3Client s3Client;
    private final String certificateFile;
    private final String privateKeyFile;

    public S3CertificateProvider(S3Client s3Client, String certificateFile, String privateKeyFile) {
        this.s3Client = Objects.requireNonNull(s3Client);
        this.certificateFile = Objects.requireNonNull(certificateFile);
        this.privateKeyFile = Objects.requireNonNull(privateKeyFile);
    }

    @Override
    public Certificate getCertificate() {
        try {
            URI certificateFileUri = new URI(this.certificateFile);
            URI privateKeyFileUri = new URI(this.privateKeyFile);
            String certificate = this.getObjectWithKey(certificateFileUri.getHost(), certificateFileUri.getPath().substring(1));
            String privateKey = this.getObjectWithKey(privateKeyFileUri.getHost(), privateKeyFileUri.getPath().substring(1));
            return new Certificate(certificate, privateKey);
        }
        catch (URISyntaxException ex) {
            LOG.error("Error encountered while parsing the certificate's Amazon S3 URI.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private String getObjectWithKey(String bucketName, String key) {
        String string;
        block8: {
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(key).build();
            ResponseInputStream s3Object = this.s3Client.getObject(getObjectRequest);
            try {
                LOG.info("Object with key \"{}\" downloaded.", (Object)key);
                string = IOUtils.toString((InputStream)s3Object, (Charset)StandardCharsets.UTF_8);
                if (s3Object == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s3Object != null) {
                        try {
                            s3Object.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error("Error encountered while processing the response from Amazon S3.", (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            s3Object.close();
        }
        return string;
    }
}

