/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.common.utils;

import com.linecorp.armeria.client.retry.Backoff;
import org.slf4j.Logger;

public class RetryUtil {
    private static final long DEFAULT_BASE_DELAY_MS = 100L;
    private static final long DEFAULT_MAX_DELAY_MS = 1000L;
    private static final int DEFAULT_MAX_RETRIES = 3;

    public static boolean retryWithBackoff(Runnable task, Logger log) {
        return RetryUtil.retryWithBackoff(task, 100L, 1000L, 3, log);
    }

    public static boolean retryWithBackoff(Runnable task, long baseDelayMs, long maxDelayMs, int maxRetries, Logger log) {
        Backoff backoff = Backoff.exponential((long)baseDelayMs, (long)maxDelayMs).withMaxAttempts(maxRetries);
        int attempt = 1;
        while (true) {
            try {
                task.run();
                return true;
            }
            catch (Exception e) {
                long delayMillis = backoff.nextDelayMillis(attempt++);
                if (delayMillis < 0L) {
                    log.error("Max retries ({}) reached. Last exception: {}", new Object[]{maxRetries, e.getMessage(), e});
                    return false;
                }
                log.warn("Retry attempt {} failed. Retrying in {} ms...", (Object)(attempt - 1), (Object)delayMillis);
                try {
                    Thread.sleep(delayMillis);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    log.error("Retry thread interrupted", (Throwable)ie);
                    return false;
                }
            }
        }
    }
}

