/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.model.constraints.ByteCountMax;
import org.opensearch.dataprepper.model.constraints.ByteCountMin;
import org.opensearch.dataprepper.model.types.ByteCount;

public class ThresholdConfig {
    public static final long ONE_MB = 0x100000L;
    public static final int DEFAULT_BATCH_SIZE = 25;
    public static final ByteCount DEFAULT_MAX_EVENT_SIZE = ByteCount.parse((String)"1mb");
    public static final ByteCount DEFAULT_MAX_REQUEST_SIZE = ByteCount.parse((String)"1mb");
    public static final long DEFAULT_FLUSH_INTERVAL = 60L;
    @JsonProperty(value="batch_size", defaultValue="25")
    @Min(value=1L)
    @Max(value=10000L)
    private @Min(value=1L) @Max(value=10000L) int batchSize = 25;
    @JsonProperty(value="max_event_size", defaultValue="1mb")
    @ByteCountMin(value="1b")
    @ByteCountMax(value="1mb")
    private @ByteCountMin(value="1b") @ByteCountMax(value="1mb") ByteCount maxEventSize = DEFAULT_MAX_EVENT_SIZE;
    @JsonProperty(value="max_request_size", defaultValue="1mb")
    @ByteCountMin(value="1b")
    @ByteCountMax(value="1mb")
    private @ByteCountMin(value="1b") @ByteCountMax(value="1mb") ByteCount maxRequestSize = DEFAULT_MAX_REQUEST_SIZE;
    @JsonProperty(value="flush_interval")
    @DurationMin(seconds=10L)
    @DurationMax(seconds=3600L)
    private @DurationMin(seconds=10L) @DurationMax(seconds=3600L) Duration flushInterval = Duration.ofSeconds(60L);

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getMaxEventSizeBytes() {
        return this.maxEventSize.getBytes();
    }

    public long getMaxRequestSizeBytes() {
        return this.maxRequestSize.getBytes();
    }

    public long getFlushInterval() {
        return this.flushInterval.getSeconds();
    }
}

