/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.model.types.ByteCount;

public class ThresholdConfig {
    public static final int DEFAULT_BATCH_SIZE = 25;
    public static final String DEFAULT_EVENT_SIZE = "256kb";
    public static final String DEFAULT_SIZE_OF_REQUEST = "1mb";
    public static final long DEFAULT_FLUSH_INTERVAL = 60L;
    @JsonProperty(value="batch_size", defaultValue="25")
    @Min(value=1L)
    @Max(value=10000L)
    private @Min(value=1L) @Max(value=10000L) int batchSize = 25;
    @JsonProperty(value="max_event_size", defaultValue="256k")
    @Size(min=1, max=256, message="max_event_size amount should be between 1 to 256 kilobytes")
    private @Size(min=1, max=256, message="max_event_size amount should be between 1 to 256 kilobytes") String maxEventSize = "256kb";
    @JsonProperty(value="max_request_size", defaultValue="1mb")
    private String maxRequestSize = "1mb";
    @JsonProperty(value="flush_interval")
    @DurationMin(seconds=60L)
    @DurationMax(seconds=3600L)
    private @DurationMin(seconds=60L) @DurationMax(seconds=3600L) Duration flushInterval = Duration.ofSeconds(60L);

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getMaxEventSizeBytes() {
        return ByteCount.parse((String)this.maxEventSize).getBytes();
    }

    public long getMaxRequestSizeBytes() {
        return ByteCount.parse((String)this.maxRequestSize).getBytes();
    }

    public long getFlushInterval() {
        return this.flushInterval.getSeconds();
    }
}

