/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws;

import org.opensearch.dataprepper.model.annotations.DataPrepperExtensionPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.plugin.ExtensionPlugin;
import org.opensearch.dataprepper.model.plugin.ExtensionPoints;
import org.opensearch.dataprepper.model.plugin.ExtensionProvider;
import org.opensearch.dataprepper.plugins.aws.AwsExtensionProvider;
import org.opensearch.dataprepper.plugins.aws.AwsPluginConfig;
import org.opensearch.dataprepper.plugins.aws.AwsStsConfiguration;
import org.opensearch.dataprepper.plugins.aws.CredentialsCache;
import org.opensearch.dataprepper.plugins.aws.CredentialsProviderFactory;
import org.opensearch.dataprepper.plugins.aws.DefaultAwsCredentialsSupplier;

@DataPrepperExtensionPlugin(modelType=AwsPluginConfig.class, rootKeyJsonPath="/aws/configurations")
public class AwsPlugin
implements ExtensionPlugin {
    private final DefaultAwsCredentialsSupplier defaultAwsCredentialsSupplier;
    private final AwsPluginConfig awsPluginConfig;

    @DataPrepperPluginConstructor
    public AwsPlugin(AwsPluginConfig awsPluginConfig) {
        this.awsPluginConfig = awsPluginConfig;
        CredentialsProviderFactory credentialsProviderFactory = new CredentialsProviderFactory(awsPluginConfig != null ? awsPluginConfig.getDefaultStsConfiguration() : new AwsStsConfiguration());
        CredentialsCache credentialsCache = new CredentialsCache();
        this.defaultAwsCredentialsSupplier = new DefaultAwsCredentialsSupplier(credentialsProviderFactory, credentialsCache);
    }

    public void apply(ExtensionPoints extensionPoints) {
        extensionPoints.addExtensionProvider((ExtensionProvider)new AwsExtensionProvider(this.defaultAwsCredentialsSupplier));
    }
}

