/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.aws.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public final class AwsRequestSigningApache4Interceptor
implements HttpRequestInterceptor {
    private static final String CONTENT_LENGTH = "content-length";
    private static final String ZERO_CONTENT_LENGTH = "0";
    private static final String HOST = "host";
    private final String service;
    private final Signer signer;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final Region region;

    public AwsRequestSigningApache4Interceptor(String service, Signer signer, AwsCredentialsProvider awsCredentialsProvider, Region region) {
        this.service = Objects.requireNonNull(service);
        this.signer = Objects.requireNonNull(signer);
        this.awsCredentialsProvider = Objects.requireNonNull(awsCredentialsProvider);
        this.region = Objects.requireNonNull(region);
    }

    public AwsRequestSigningApache4Interceptor(String service, Signer signer, AwsCredentialsProvider awsCredentialsProvider, String region) {
        this(service, signer, awsCredentialsProvider, Region.of((String)region));
    }

    public void process(HttpRequest request, HttpContext context) throws IOException {
        HttpEntityEnclosingRequest httpEntityEnclosingRequest;
        HttpEntityEnclosingRequest httpEntityEnclosingRequest2;
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(request.getRequestLine().getUri());
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI", e);
        }
        SdkHttpFullRequest.Builder requestBuilder = SdkHttpFullRequest.builder().method(SdkHttpMethod.fromValue((String)request.getRequestLine().getMethod())).uri(this.buildUri(context, uriBuilder));
        if (request instanceof HttpEntityEnclosingRequest && (httpEntityEnclosingRequest2 = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            InputStream content = httpEntityEnclosingRequest2.getEntity().getContent();
            requestBuilder.contentStreamProvider(() -> content);
        }
        requestBuilder.rawQueryParameters(AwsRequestSigningApache4Interceptor.nvpToMapParams(uriBuilder.getQueryParams()));
        requestBuilder.headers(AwsRequestSigningApache4Interceptor.headerArrayToMap(request.getAllHeaders()));
        ExecutionAttributes attributes = new ExecutionAttributes();
        attributes.putAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS, (Object)this.awsCredentialsProvider.resolveCredentials());
        attributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, (Object)this.service);
        attributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, (Object)this.region);
        SdkHttpFullRequest signedRequest = this.signer.sign(requestBuilder.build(), attributes);
        request.setHeaders(AwsRequestSigningApache4Interceptor.mapToHeaderArray(signedRequest.headers()));
        if (request instanceof HttpEntityEnclosingRequest && (httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
            basicHttpEntity.setContent(((ContentStreamProvider)signedRequest.contentStreamProvider().orElseThrow(() -> new IllegalStateException("There must be content"))).newStream());
            httpEntityEnclosingRequest.setEntity((HttpEntity)basicHttpEntity);
        }
    }

    private URI buildUri(HttpContext context, URIBuilder uriBuilder) throws IOException {
        try {
            HttpHost host = (HttpHost)context.getAttribute("http.target_host");
            if (host != null) {
                uriBuilder.setHost(host.getHostName());
                uriBuilder.setScheme(host.getSchemeName());
                uriBuilder.setPort(host.getPort());
            }
            return uriBuilder.build();
        }
        catch (Exception e) {
            throw new IOException("Invalid URI", e);
        }
    }

    private static Map<String, List<String>> nvpToMapParams(List<NameValuePair> params) {
        TreeMap<String, List<String>> parameterMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (NameValuePair nvp : params) {
            List argsList = parameterMap.computeIfAbsent(nvp.getName(), k -> new ArrayList());
            argsList.add(nvp.getValue());
        }
        return parameterMap;
    }

    private static Map<String, List<String>> headerArrayToMap(Header[] headers) {
        TreeMap<String, List<String>> headersMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : headers) {
            if (AwsRequestSigningApache4Interceptor.skipHeader(header)) continue;
            headersMap.put(header.getName(), (List<String>)headersMap.getOrDefault(header.getName(), new LinkedList<String>(Collections.singletonList(header.getValue()))));
        }
        return headersMap;
    }

    private static boolean skipHeader(Header header) {
        return CONTENT_LENGTH.equalsIgnoreCase(header.getName()) && ZERO_CONTENT_LENGTH.equals(header.getValue()) || HOST.equalsIgnoreCase(header.getName());
    }

    private static Header[] mapToHeaderArray(Map<String, List<String>> mapHeaders) {
        Header[] headers = new Header[mapHeaders.size()];
        int i = 0;
        for (Map.Entry<String, List<String>> headerEntry : mapHeaders.entrySet()) {
            for (String value : headerEntry.getValue()) {
                headers[i++] = new BasicHeader(headerEntry.getKey(), value);
            }
        }
        return headers;
    }
}

