/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.common.codec;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;

@Deprecated
public class LambdaJsonCodec
implements OutputCodec {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final String JSON = "json";
    private static final JsonFactory factory = new JsonFactory();
    private JsonGenerator generator;
    private OutputCodecContext codecContext;
    private final String keyName;

    public LambdaJsonCodec(String keyName) {
        this.keyName = keyName;
    }

    public String getExtension() {
        return JSON;
    }

    public void start(OutputStream outputStream, Event event, OutputCodecContext codecContext) throws IOException {
        Objects.requireNonNull(outputStream);
        this.codecContext = codecContext;
        this.generator = factory.createGenerator(outputStream, JsonEncoding.UTF8);
        if (Objects.nonNull(this.keyName)) {
            this.generator.writeStartObject();
            this.generator.writeFieldName(this.keyName);
            this.generator.writeStartArray();
        }
    }

    public void complete(OutputStream outputStream) throws IOException {
        if (!Objects.isNull(this.keyName)) {
            this.generator.writeEndArray();
            this.generator.writeEndObject();
        }
        this.generator.close();
        outputStream.flush();
        outputStream.close();
    }

    public synchronized void writeEvent(Event event, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(event);
        if (Objects.isNull(this.keyName)) {
            Map eventMap = event.toMap();
            this.objectMapper.writeValue(outputStream, (Object)eventMap);
        } else {
            Map dataMap = event.toMap();
            this.objectMapper.writeValue(this.generator, (Object)dataMap);
        }
        this.generator.flush();
    }
}

