/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.atlassian.rest.auth;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.plugins.source.atlassian.AtlassianSourceConfig;
import org.opensearch.dataprepper.plugins.source.atlassian.configuration.Oauth2Config;
import org.opensearch.dataprepper.plugins.source.atlassian.rest.auth.AtlassianAuthConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.exception.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class AtlassianOauthConfig
implements AtlassianAuthConfig {
    public static final String OAuth2_URL = "https://api.atlassian.com/ex/";
    public static final String ACCESSIBLE_RESOURCES = "https://api.atlassian.com/oauth/token/accessible-resources";
    public static final String TOKEN_LOCATION = "https://auth.atlassian.com/oauth/token";
    public static final String EXPIRES_IN = "expires_in";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String ACCESS_TOKEN = "access_token";
    private static final Logger log = LoggerFactory.getLogger(AtlassianOauthConfig.class);
    RestTemplate restTemplate = new RestTemplate();
    private String url;
    private int expiresInSeconds = 0;
    private Instant expireTime = Instant.ofEpochMilli(0L);
    private String accessToken;
    private String refreshToken;
    private String cloudId = null;
    private final String clientId;
    private final String clientSecret;
    private final AtlassianSourceConfig atlassianSourceConfig;
    private final Object cloudIdFetchLock = new Object();
    private final Object tokenRenewLock = new Object();

    public AtlassianOauthConfig(AtlassianSourceConfig atlassianSourceConfig) {
        this.atlassianSourceConfig = atlassianSourceConfig;
        this.accessToken = (String)atlassianSourceConfig.getAuthenticationConfig().getOauth2Config().getAccessToken().getValue();
        this.refreshToken = (String)atlassianSourceConfig.getAuthenticationConfig().getOauth2Config().getRefreshToken().getValue();
        this.clientId = atlassianSourceConfig.getAuthenticationConfig().getOauth2Config().getClientId();
        this.clientSecret = atlassianSourceConfig.getAuthenticationConfig().getOauth2Config().getClientSecret();
    }

    public String getAtlassianAccountCloudId() {
        log.info("Getting Atlassian Account Cloud ID");
        Object object = this.cloudIdFetchLock;
        synchronized (object) {
            if (this.cloudId != null) {
                return this.cloudId;
            }
            int retryCount = 0;
            while (retryCount < 6) {
                ++retryCount;
                try {
                    HttpHeaders headers = new HttpHeaders();
                    headers.setBearerAuth(this.accessToken);
                    headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                    HttpEntity entity = new HttpEntity((MultiValueMap)headers);
                    ResponseEntity exchangeResponse = this.restTemplate.exchange(ACCESSIBLE_RESOURCES, HttpMethod.GET, entity, Object.class, new Object[0]);
                    List listResponse = (List)exchangeResponse.getBody();
                    Map response = (Map)listResponse.get(0);
                    this.cloudId = (String)response.get("id");
                    return this.cloudId;
                }
                catch (HttpClientErrorException e) {
                    if (e.getRawStatusCode() == HttpStatus.UNAUTHORIZED.value()) {
                        this.renewCredentials();
                    }
                    log.error("Error occurred while accessing resources: ", (Throwable)e);
                }
            }
            throw new UnauthorizedException(String.format("Access token expired. Unable to renew even after %s attempts", 6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewCredentials() {
        Instant currentTime = Instant.now();
        if (this.expireTime.isAfter(currentTime)) {
            return;
        }
        Object object = this.tokenRenewLock;
        synchronized (object) {
            if (this.expireTime.isAfter(currentTime)) {
                return;
            }
            log.info("Renewing access token and refresh token pair for Atlassian Connector.");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String payloadTemplate = "{\"grant_type\": \"%s\", \"client_id\": \"%s\", \"client_secret\": \"%s\", \"refresh_token\": \"%s\"}";
            String payload = String.format(payloadTemplate, REFRESH_TOKEN, this.clientId, this.clientSecret, this.refreshToken);
            HttpEntity entity = new HttpEntity((Object)payload, (MultiValueMap)headers);
            Oauth2Config oauth2Config = this.atlassianSourceConfig.getAuthenticationConfig().getOauth2Config();
            try {
                ResponseEntity responseEntity = this.restTemplate.postForEntity(TOKEN_LOCATION, (Object)entity, Map.class, new Object[0]);
                Map oauthClientResponse = (Map)responseEntity.getBody();
                this.accessToken = (String)oauthClientResponse.get(ACCESS_TOKEN);
                this.refreshToken = (String)oauthClientResponse.get(REFRESH_TOKEN);
                this.expiresInSeconds = (Integer)oauthClientResponse.get(EXPIRES_IN);
                this.expireTime = Instant.now().plusSeconds(this.expiresInSeconds);
                oauth2Config.getAccessToken().setValue((Object)this.accessToken);
                oauth2Config.getRefreshToken().setValue((Object)this.refreshToken);
                log.info("Access Token and Refresh Token pair is now refreshed. Corresponding Secret store key updated.");
            }
            catch (HttpClientErrorException ex) {
                this.expireTime = Instant.ofEpochMilli(0L);
                this.expiresInSeconds = 0;
                HttpStatus statusCode = ex.getStatusCode();
                log.error("Failed to renew access token. Status code: {}, Error Message: {}", (Object)statusCode, (Object)ex.getMessage());
                if (statusCode == HttpStatus.FORBIDDEN || statusCode == HttpStatus.UNAUTHORIZED) {
                    log.info("Trying to refresh the secrets");
                    oauth2Config.getAccessToken().refresh();
                    this.accessToken = (String)oauth2Config.getAccessToken().getValue();
                    this.refreshToken = (String)oauth2Config.getRefreshToken().getValue();
                    this.expireTime = Instant.now().plusSeconds(10L);
                }
                throw new RuntimeException("Failed to renew access token message:" + ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUrl() {
        if (!StringUtils.hasLength((String)this.url)) {
            Object object = this.cloudIdFetchLock;
            synchronized (object) {
                if (!StringUtils.hasLength((String)this.url)) {
                    this.initCredentials();
                }
            }
        }
        return this.url;
    }

    @Override
    public void initCredentials() {
        this.cloudId = this.getAtlassianAccountCloudId();
        this.url = OAuth2_URL + this.atlassianSourceConfig.getOauth2UrlContext() + "/" + this.cloudId + "/";
    }

    public int getExpiresInSeconds() {
        return this.expiresInSeconds;
    }

    public Instant getExpireTime() {
        return this.expireTime;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }
}

