/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate.actions;

import com.google.common.util.concurrent.RateLimiter;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateAction;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionInput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionResponse;
import org.opensearch.dataprepper.plugins.processor.aggregate.actions.RateLimiterAggregateActionConfig;
import org.opensearch.dataprepper.plugins.processor.aggregate.actions.RateLimiterMode;

@DataPrepperPlugin(name="rate_limiter", pluginType=AggregateAction.class, pluginConfigurationType=RateLimiterAggregateActionConfig.class)
public class RateLimiterAggregateAction
implements AggregateAction {
    private final RateLimiter rateLimiter;
    private final RateLimiterMode rateLimiterMode;

    @DataPrepperPluginConstructor
    public RateLimiterAggregateAction(RateLimiterAggregateActionConfig ratelimiterAggregateActionConfig) {
        int eventsPerSecond = ratelimiterAggregateActionConfig.getEventsPerSecond();
        this.rateLimiterMode = ratelimiterAggregateActionConfig.getWhenExceeds();
        this.rateLimiter = RateLimiter.create((double)eventsPerSecond);
    }

    @Override
    public AggregateActionResponse handleEvent(Event event, AggregateActionInput aggregateActionInput) {
        if (this.rateLimiterMode == RateLimiterMode.DROP) {
            if (!this.rateLimiter.tryAcquire()) {
                return AggregateActionResponse.nullEventResponse();
            }
        } else {
            this.rateLimiter.acquire();
        }
        return new AggregateActionResponse(event);
    }
}

