/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate.actions;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateAction;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionInput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionOutput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionResponse;
import org.opensearch.dataprepper.plugins.processor.aggregate.GroupState;
import org.opensearch.dataprepper.plugins.processor.aggregate.actions.AppendAggregateActionConfig;

@DataPrepperPlugin(name="append", pluginType=AggregateAction.class, pluginConfigurationType=AppendAggregateActionConfig.class)
public class AppendAggregateAction
implements AggregateAction {
    static final String EVENT_TYPE = "event";
    public final List<String> keysToAppend;

    @DataPrepperPluginConstructor
    public AppendAggregateAction(AppendAggregateActionConfig appendAggregateActionConfig) {
        this.keysToAppend = appendAggregateActionConfig.getKeysToAppend();
    }

    @Override
    public AggregateActionResponse handleEvent(Event event, AggregateActionInput aggregateActionInput) {
        GroupState groupState = aggregateActionInput.getGroupState();
        if (groupState.size() == 0) {
            groupState.putAll(event.toMap());
            return AggregateActionResponse.nullEventResponse();
        }
        this.consumeEvent(groupState, event);
        return AggregateActionResponse.nullEventResponse();
    }

    private void consumeEvent(GroupState groupState, Event event) {
        event.toMap().forEach((key, value) -> {
            if (this.keysToAppend == null || this.keysToAppend.isEmpty() || this.keysToAppend.contains(key)) {
                Object valueFromGroupState = groupState.getOrDefault(key, value);
                if (valueFromGroupState instanceof List) {
                    if (value instanceof List) {
                        ((List)valueFromGroupState).addAll((List)value);
                    } else {
                        ((List)valueFromGroupState).add(value);
                    }
                } else if (!Objects.equals(value, valueFromGroupState)) {
                    groupState.put(key, Arrays.asList(valueFromGroupState, value));
                }
            }
        });
    }

    @Override
    public AggregateActionOutput concludeGroup(AggregateActionInput aggregateActionInput) {
        if (aggregateActionInput.getGroupState().isEmpty()) {
            return null;
        }
        JacksonEvent event = JacksonEvent.builder().withEventType(EVENT_TYPE).withData((Object)aggregateActionInput.getGroupState()).withEventHandle(aggregateActionInput.getEventHandle()).build();
        return new AggregateActionOutput(List.of(event));
    }
}

