/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.opensearch.dataprepper.model.event.AggregateEventHandle;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.event.InternalEventHandle;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionInput;
import org.opensearch.dataprepper.plugins.processor.aggregate.DefaultGroupState;
import org.opensearch.dataprepper.plugins.processor.aggregate.GroupState;

class AggregateGroup
implements AggregateActionInput {
    private final GroupState groupState = new DefaultGroupState();
    private Instant groupStart;
    private final Lock concludeGroupLock;
    private final Lock handleEventForGroupLock;
    private final Map<Object, Object> identificationKeys;
    private Function<Duration, Boolean> customShouldConclude;
    private EventHandle eventHandle;

    AggregateGroup(Map<Object, Object> identificationKeys) {
        this.identificationKeys = identificationKeys;
        this.groupStart = Instant.now();
        this.concludeGroupLock = new ReentrantLock();
        this.handleEventForGroupLock = new ReentrantLock();
        this.eventHandle = new AggregateEventHandle(Instant.now());
    }

    @Override
    public EventHandle getEventHandle() {
        return this.eventHandle;
    }

    public void attachToEventAcknowledgementSet(Event event) {
        EventHandle handle = event.getEventHandle();
        InternalEventHandle internalEventHandle = (InternalEventHandle)handle;
        internalEventHandle.addEventHandle(this.eventHandle);
    }

    @Override
    public GroupState getGroupState() {
        return this.groupState;
    }

    @Override
    public Map<Object, Object> getIdentificationKeys() {
        return this.identificationKeys;
    }

    Instant getGroupStart() {
        return this.groupStart;
    }

    Lock getConcludeGroupLock() {
        return this.concludeGroupLock;
    }

    @Override
    public void setCustomShouldConclude(Function<Duration, Boolean> shouldConclude) {
        this.customShouldConclude = shouldConclude;
    }

    Lock getHandleEventForGroupLock() {
        return this.handleEventForGroupLock;
    }

    boolean shouldConcludeGroup(Duration groupDuration) {
        if (this.customShouldConclude != null) {
            return this.customShouldConclude.apply(groupDuration);
        }
        return Duration.between(this.groupStart, Instant.now()).compareTo(groupDuration) >= 0;
    }

    void resetGroup() {
        this.groupStart = Instant.now();
        this.groupState.clear();
        this.eventHandle = new AggregateEventHandle(this.groupStart);
    }
}

