/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate.actions;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>percent_sampler</code> action controls the number of events aggregated based on a percentage of events. The action drops any events not included in the percentage.")
public class PercentSamplerAggregateActionConfig {
    @JsonPropertyDescription(value="The percentage of events to be processed during a one second interval. Must be greater than 0.0 and less than 100.0.")
    @JsonProperty(value="percent")
    @NotNull
    private double percent;

    @AssertTrue(message="Percent value must be greater than 0.0 and less than 100.0")
    @AssertTrue(message="Percent value must be greater than 0.0 and less than 100.0") boolean isPercentValid() {
        return this.percent > 0.0 && this.percent < 100.0;
    }

    public double getPercent() {
        return this.percent;
    }
}

