/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.metric;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.metric.Bucket;
import org.opensearch.dataprepper.model.metric.DefaultBucket;
import org.opensearch.dataprepper.model.metric.ExponentialHistogram;
import org.opensearch.dataprepper.model.metric.JacksonMetric;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.metric.ParameterValidator;

public class JacksonExponentialHistogram
extends JacksonMetric
implements ExponentialHistogram {
    private static final String SUM_KEY = "sum";
    private static final String COUNT_KEY = "count";
    private static final String SCALE_KEY = "scale";
    private static final String AGGREGATION_TEMPORALITY_KEY = "aggregationTemporality";
    private static final String ZERO_COUNT_KEY = "zeroCount";
    public static final String POSITIVE_BUCKETS_KEY = "positiveBuckets";
    public static final String NEGATIVE_BUCKETS_KEY = "negativeBuckets";
    private static final String NEGATIVE_KEY = "negative";
    private static final String POSITIVE_KEY = "positive";
    private static final String NEGATIVE_OFFSET_KEY = "negativeOffset";
    private static final String POSITIVE_OFFSET_KEY = "positiveOffset";
    private static final List<String> REQUIRED_KEYS = new ArrayList<String>();
    private static final List<String> REQUIRED_NON_EMPTY_KEYS = Arrays.asList("name", "kind", "time");
    private static final List<String> REQUIRED_NON_NULL_KEYS = Collections.singletonList("sum");

    protected JacksonExponentialHistogram(Builder builder, boolean flattenAttributes) {
        super(builder, flattenAttributes);
        Preconditions.checkArgument((boolean)this.getMetadata().getEventType().equals(EventType.METRIC.toString()), (Object)"eventType must be of type Metric");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Double getSum() {
        return this.get(SUM_KEY, Double.class);
    }

    @Override
    public Long getCount() {
        return this.get(COUNT_KEY, Long.class);
    }

    @Override
    public String getAggregationTemporality() {
        return this.get(AGGREGATION_TEMPORALITY_KEY, String.class);
    }

    @Override
    public List<? extends Bucket> getNegativeBuckets() {
        return this.getList(NEGATIVE_BUCKETS_KEY, DefaultBucket.class);
    }

    @Override
    public List<? extends Bucket> getPositiveBuckets() {
        return this.getList(POSITIVE_BUCKETS_KEY, DefaultBucket.class);
    }

    @Override
    public List<Long> getNegative() {
        return this.getList(NEGATIVE_KEY, Long.class);
    }

    @Override
    public List<Long> getPositive() {
        return this.getList(POSITIVE_KEY, Long.class);
    }

    @Override
    public Long getZeroCount() {
        return this.get(ZERO_COUNT_KEY, Long.class);
    }

    @Override
    public Integer getScale() {
        return this.get(SCALE_KEY, Integer.class);
    }

    @Override
    public Integer getNegativeOffset() {
        return this.get(NEGATIVE_OFFSET_KEY, Integer.class);
    }

    @Override
    public Integer getPositiveOffset() {
        return this.get(POSITIVE_OFFSET_KEY, Integer.class);
    }

    public static class Builder
    extends JacksonMetric.Builder<Builder> {
        @Override
        public Builder getThis() {
            return this;
        }

        public Builder withSum(double sum) {
            this.data.put(JacksonExponentialHistogram.SUM_KEY, sum);
            return this;
        }

        public Builder withCount(long count) {
            this.data.put(JacksonExponentialHistogram.COUNT_KEY, count);
            return this;
        }

        public Builder withScale(int scale) {
            this.data.put(JacksonExponentialHistogram.SCALE_KEY, scale);
            return this;
        }

        public Builder withZeroCount(long zeroCount) {
            this.data.put(JacksonExponentialHistogram.ZERO_COUNT_KEY, zeroCount);
            return this;
        }

        public Builder withAggregationTemporality(String aggregationTemporality) {
            this.data.put(JacksonExponentialHistogram.AGGREGATION_TEMPORALITY_KEY, aggregationTemporality);
            return this;
        }

        public Builder withPositiveBuckets(List<Bucket> exponentialBuckets) {
            this.data.put(JacksonExponentialHistogram.POSITIVE_BUCKETS_KEY, exponentialBuckets);
            return this;
        }

        public Builder withNegativeBuckets(List<Bucket> exponentialBuckets) {
            this.data.put(JacksonExponentialHistogram.NEGATIVE_BUCKETS_KEY, exponentialBuckets);
            return this;
        }

        public Builder withPositive(List<Long> bucketCountsList) {
            this.data.put(JacksonExponentialHistogram.POSITIVE_KEY, bucketCountsList);
            return this;
        }

        public Builder withNegative(List<Long> bucketCountsList) {
            this.data.put(JacksonExponentialHistogram.NEGATIVE_KEY, bucketCountsList);
            return this;
        }

        public Builder withPositiveOffset(int offset) {
            this.data.put(JacksonExponentialHistogram.POSITIVE_OFFSET_KEY, offset);
            return this;
        }

        public Builder withNegativeOffset(int offset) {
            this.data.put(JacksonExponentialHistogram.NEGATIVE_OFFSET_KEY, offset);
            return this;
        }

        @Override
        public JacksonExponentialHistogram build() {
            return this.build(true);
        }

        public JacksonExponentialHistogram build(boolean flattenAttributes) {
            this.withData(this.data);
            this.withEventKind(Metric.KIND.EXPONENTIAL_HISTOGRAM.toString());
            this.withEventType(EventType.METRIC.toString());
            this.checkAndSetDefaultValues();
            new ParameterValidator().validate(REQUIRED_KEYS, REQUIRED_NON_EMPTY_KEYS, REQUIRED_NON_NULL_KEYS, this.data);
            return new JacksonExponentialHistogram(this, flattenAttributes);
        }

        private void checkAndSetDefaultValues() {
            this.data.computeIfAbsent("attributes", k -> new HashMap());
        }
    }
}

