/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.buffer;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.opensearch.dataprepper.model.CheckpointState;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.record.Record;

public abstract class DelegatingBuffer<T extends Record<?>>
implements Buffer<T> {
    private final Buffer<T> delegateBuffer;

    protected DelegatingBuffer(Buffer<T> delegateBuffer) {
        this.delegateBuffer = Objects.requireNonNull(delegateBuffer);
    }

    @Override
    public void write(T record, int timeoutInMillis) throws TimeoutException {
        this.delegateBuffer.write(record, timeoutInMillis);
    }

    @Override
    public void writeAll(Collection<T> records, int timeoutInMillis) throws Exception {
        this.delegateBuffer.writeAll(records, timeoutInMillis);
    }

    @Override
    public void writeBytes(byte[] bytes, String key, int timeoutInMillis) throws Exception {
        this.delegateBuffer.writeBytes(bytes, key, timeoutInMillis);
    }

    @Override
    public Map.Entry<Collection<T>, CheckpointState> read(int timeoutInMillis) {
        return this.delegateBuffer.read(timeoutInMillis);
    }

    @Override
    public void checkpoint(CheckpointState checkpointState) {
        this.delegateBuffer.checkpoint(checkpointState);
    }

    @Override
    public boolean isEmpty() {
        return this.delegateBuffer.isEmpty();
    }

    @Override
    public boolean isByteBuffer() {
        return this.delegateBuffer.isByteBuffer();
    }

    @Override
    public Duration getDrainTimeout() {
        return this.delegateBuffer.getDrainTimeout();
    }

    @Override
    public boolean isWrittenOffHeapOnly() {
        return this.delegateBuffer.isWrittenOffHeapOnly();
    }

    @Override
    public void shutdown() {
        this.delegateBuffer.shutdown();
    }
}

